% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,zelig-method}
\alias{extract,zelig-method}
\alias{extract.zelig}
\alias{extract,Zelig-method}
\alias{extract.Zelig}
\title{\code{\link{extract}} method for \code{zelig} objects}
\usage{
\S4method{extract}{zelig}(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.deviance = TRUE,
  include.nobs = TRUE,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.fstatistic = TRUE,
  ...
)

\S4method{extract}{Zelig}(model, include.nobs = TRUE, include.nimp = TRUE, ...)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.deviance}{Report the deviance?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.adjrs}{Report adjusted R^2 in the GOF block?}

\item{include.fstatistic}{Report the F-statistic in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}

\item{include.nimp}{Report the number of multiple imputations (in Zelig
models with imputed data)?}
}
\description{
\code{\link{extract}} method for \code{zelig} objects created by the
\code{zelig} function in the \pkg{Zelig} package (version < 5.0).

\code{\link{extract}} method for \code{Zelig} objects created by the
\code{zelig} function in the \pkg{Zelig} package (version >= 5.0).
}
