% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{coeftostring}
\alias{coeftostring}
\title{Convert a number into a string with rounded decimal places}
\usage{
coeftostring(x, lead.zero = FALSE, digits = 2)
}
\arguments{
\item{x}{A \code{numeric} object to reformat.}

\item{lead.zero}{Should a leading zero be printed if the coefficient is
non-negative and smaller than one (e.g., \code{"0.23"} as opposed to
\code{".23"})?}

\item{digits}{Number of decimal places to round to.}
}
\value{
A reformatted coefficient string as a \code{character} object.
}
\description{
Reformat a coefficient as a string with a certain number of decimal places.
}
\details{
This function takes a \code{numeric} object, usually a coefficient from a
statistical model, and converts it into a \code{character} object. The user
can choose to how many decimal places the number is rounded (usually two in
most published regression models) and whether there should be a leading zero
if the coefficient is between 0 and 1.
}
\seealso{
\code{\link{texreg}}
}
\author{
Philip Leifeld
}
\keyword{internal}
