% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,gamlss-method}
\alias{extract,gamlss-method}
\alias{extract.gamlss}
\title{\code{\link{extract}} method for \code{gamlss} objects}
\usage{
\S4method{extract}{gamlss}(
  model,
  robust = FALSE,
  include.nobs = TRUE,
  include.nagelkerke = TRUE,
  include.gaic = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{robust}{If TRUE computes robust standard errors in the
variance-covariance matrix.}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.nagelkerke}{Report Nagelkerke R^2 in the GOF block?}

\item{include.gaic}{Report Generalized Akaike's Information Criterion (AIC)
in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{vcov} method for the object.}
}
\description{
\code{\link{extract}} method for \code{gamlss} objects created by the
\code{\link[gamlss]{gamlss}} function in the \pkg{gamlss} package.
}
