\name{extract-methods}
\docType{methods}
\alias{extract-methods}
\alias{extract,aftreg-method}
\alias{extract,Arima-method}
\alias{extract,betareg-method}
\alias{extract,brglm-method}
\alias{extract,btergm-method}
\alias{extract,clm-method}
\alias{extract,clogit-method}
\alias{extract,coeftest-method}
\alias{extract,coxph-method}
\alias{extract,coxph.penal-method}
\alias{extract,dynlm-method}
\alias{extract,ergm-method}
\alias{extract,fGARCH-method}
\alias{extract,gam-method}
\alias{extract,gamlss-method}
\alias{extract,gee-method}
\alias{extract,glm-method}
\alias{extract,glmerMod-method}
\alias{extract,glmmadmb-method}
\alias{extract,glmrob-method}
\alias{extract,gls-method}
\alias{extract,gmm-method}
\alias{extract,hurdle-method}
\alias{extract,ivreg-method}
\alias{extract,lm-method}
\alias{extract,lme-method}
\alias{extract,lme4-method}
\alias{extract,lmerMod-method}
\alias{extract,lmrob-method}
\alias{extract,lnam-method}
\alias{extract,lrm-method}
\alias{extract,maBina-method}
\alias{extract,mer-method}
\alias{extract,mnlogit-method}
\alias{extract,multinom-method}
\alias{extract,negbin-method}
\alias{extract,nlme-method}
\alias{extract,nlmerMod-method}
\alias{extract,ols-method}
\alias{extract,pgmm-method}
\alias{extract,phreg-method}
\alias{extract,plm-method}
\alias{extract,pmg-method}
\alias{extract,polr-method}
\alias{extract,rem.dyad-method}
\alias{extract,rlm-method}
\alias{extract,rq-method}
\alias{extract,sarlm-method}
\alias{extract,sclm-method}
\alias{extract,sienaFit-method}
\alias{extract,simex-method}
\alias{extract,stergm-method}
\alias{extract,survreg-method}
\alias{extract,survreg.penal-method}
\alias{extract,svyglm-method}
\alias{extract,systemfit-method}
\alias{extract,texreg-method}
\alias{extract,tobit-method}
\alias{extract,weibreg-method}
\alias{extract,zelig-method}
\alias{extract,zeroinfl-method}
\title{Methods for Function \code{extract} in Package \pkg{texreg}}
\description{
Methods for function \code{extract} in package \pkg{texreg}.
}
\section{Methods}{
\describe{

\item{\code{extract.aftreg}}{
An extract function for aftreg objects from the \pkg{eha} package.
}

\item{\code{extract.Arima}}{
An extract function for Arima objects from the \pkg{stats} package.
}

\item{\code{extract.betareg}}{
An extract function for betareg objects from the \pkg{betareg} package.
}

\item{\code{extract.brglm}}{
An extract function for brglm objects from the \pkg{brglm} package.
}

\item{\code{extract.btergm}}{
An extract function for btergm objects from the \pkg{btergm} package.
}

\item{\code{extract.clm}}{
An extract function for clm objects from the \pkg{ordinal} package.
}

\item{\code{extract.clogit}}{
An extract function for clogit objects from the \pkg{survival} package.
}

\item{\code{extract.coeftest}}{
An extract function for coeftest objects from the \pkg{lmtest} package.
}

\item{\code{extract.coxph}}{
An extract function for coxph objects from the \pkg{survival} package.
}

\item{\code{extract.coxph.penal}}{
An extract function for coxph.penal objects from the \pkg{survival} package.
}

\item{\code{extract.dynlm}}{
An extract function for dynlm objects from the \pkg{dynlm} package.
}

\item{\code{extract.ergm}}{
An extract function for ergm objects from the \pkg{ergm} package.
}

\item{\code{extract.fGARCH}}{
An extract function for fGARCH objects from the \pkg{fGarch} package.
}

\item{\code{extract.gam}}{
An extract function for gam objects from the \pkg{mgcv} package.
}

\item{\code{extract.gamlss}}{
An extract function for gamlss objects from the \pkg{gamlss} package.
}

\item{\code{extract.gee}}{
An extract function for gee objects from the \pkg{gee} package.
}

\item{\code{extract.glm}}{
An extract function for glm objects from the \pkg{stats} package.
}

\item{\code{extract.glmerMod}}{
An extract function for glmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{extract.glmmadmb}}{
An extract function for glmmadmb objects from the \pkg{glmmADMB} package.
}

\item{\code{extract.glmrob}}{
An extract function for glmrob objects from the \pkg{robustbase} package.
}

\item{\code{extract.gls}}{
An extract function for gls objects from the \pkg{nlme} package.
}

\item{\code{extract.gmm}}{
An extract function for gmm objects from the \pkg{gmm} package.
}

\item{\code{extract.ivreg}}{
An extract function for ivreg objects from the \pkg{AER} package.
}

\item{\code{extract.hurdle}}{
An extract function for hurdle objects from the \pkg{pscl} package.
}

\item{\code{extract.lm}}{
An extract function for lm objects from the \pkg{stats} package.
}

\item{\code{extract.lme}}{
An extract function for lme objects from the \pkg{nlme} package.
}

\item{\code{extract.lme4}}{
An extract function for lme4 objects from the \pkg{lme4} package.
}

\item{\code{extract.lmerMod}}{
An extract function for lmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{extract.lmrob}}{
An extract function for lmrob objects from the \pkg{robustbase} package.
}

\item{\code{extract.lnam}}{
An extract function for lnam objects from the \pkg{sna} package.
}

\item{\code{extract.lrm}}{
An extract function for lrm objects from the \pkg{Design} or \pkg{rms} package.
}

\item{\code{extract.maBina}}{
An extract function for maBina objects from the \pkg{erer} package.
}

\item{\code{extract.mer}}{
An extract function for mer objects from the (old) \pkg{lme4} package.
}

\item{\code{extract.mnlogit}}{
An extract function for mnlogit objects from the \pkg{mnlogit} package.
}

\item{\code{extract.multinom}}{
An extract function for multinom objects from the \pkg{nnet} package.
}

\item{\code{extract.negbin}}{
An extract function for negbin objects from the \pkg{MASS} package.
}

\item{\code{extract.nlme}}{
An extract function for nlme objects from the \pkg{nlme} package.
}

\item{\code{extract.nlmerMod}}{
An extract function for nlmerMod objects from the (old) \pkg{lme4} package.
}

\item{\code{extract.ols}}{
An extract function for ols objects from the \pkg{rms} package.
}

\item{\code{extract.pgmm}}{
An extract function for pgmm objects from the \pkg{plm} package.
}

\item{\code{extract.phreg}}{
An extract function for phreg objects from the \pkg{eha} package.
}

\item{\code{extract.plm}}{
An extract function for plm objects from the \pkg{plm} package.
}

\item{\code{extract.pmg}}{
An extract function for pmg objects from the \pkg{plm} package.
}

\item{\code{extract.polr}}{
An extract function for polr objects from the \pkg{MASS} package.
}

\item{\code{extract.rem.dyad}}{
An extract function for rem.dyad objects from the \pkg{relevent} package.
}

\item{\code{extract.rlm}}{
An extract function for rlm objects from the \pkg{MASS} package.
}

\item{\code{extract.rq}}{
An extract function for rq objects from the \pkg{quantreg} package.
}

\item{\code{extract.sarlm}}{
An extract function for sarlm objects from the \pkg{spdep} package.
}

\item{\code{extract.sclm}}{
An extract function for sclm objects from the \pkg{ordinal} package.
}

\item{\code{extract.sienaFit}}{
An extract function for sienaFit objects from the \pkg{RSiena} package.
}

\item{\code{extract.simex}}{
An extract function for simex objects from the \pkg{simex} package.
}

\item{\code{extract.stergm}}{
An extract function for stergm objects from the \pkg{tergm} package.
}

\item{\code{extract.survreg}}{
An extract function for survreg objects from the \pkg{survival} package.
}

\item{\code{extract.survreg.penal}}{
An extract function for survreg.penal objects from the \pkg{survival} package.
}

\item{\code{extract.svyglm}}{
An extract function for svyglm objects from the \pkg{survey} package.
}

\item{\code{extract.systemfit}}{
An extract function for systemfit objects from the \pkg{systemfit} package.
}

\item{\code{extract.texreg}}{
An extract function for texreg objects from the \pkg{texreg} package. The purpose is to allow for easy manipulation of the output. \code{texreg} objects can be created using the \link{createTexreg} function or using the \link{extract} function. After manipulating the object, it can be handed back to the \link{screenreg}, \link{texreg}, or \link{htmlreg} functions for creating a table.
}

\item{\code{extract.tobit}}{
An extract function for tobit objects from the \pkg{AER} package.
}

\item{\code{extract.weibreg}}{
An extract function for weibreg objects from the \pkg{eha} package.
}

\item{\code{extract.zelig}}{
An extract function for zelig objects from the \pkg{Zelig} package. Has been tested with ls, logit and relogit models as implemented in the \pkg{Zelig} package.
}

\item{\code{extract.zeroinfl}}{
An extract function for zeroinfl objects from the \pkg{pscl} package.
}
}}
\references{
Leifeld, Philip (2013). texreg: Conversion of Statistical Model Output in R to 
LaTeX and HTML Tables. Journal of Statistical Software, 55(8), 1-24.
\url{http://www.jstatsoft.org/v55/i08/}.
}
\seealso{
\code{\link{texreg-package} \link{texreg} \link{extract}}
}
\keyword{methods}
