% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code-tools.R
\name{patch_code_env}
\alias{patch_code_env}
\title{patch all code environments}
\usage{
patch_code_env(article_dir)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}
}
\value{
patches code environments in LaTeX file and also backs up the old file before modification
, FALSE otherwise
}
\description{
This function calls the `filter_code_env()` function
over the following code environments described in Rjournal.sty

1. example
2. example*
3. Sin
4. Sout
5. Sinput
6. Soutput
7. smallverbatim
}
\examples{
# Note This is a minimal example to execute this function
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir2"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <-  xfun::normalize_path(paste(your_article_folder,"article",sep="/"))
texor::patch_code_env(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
\keyword{internal}
