% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-inheritance.R
\name{inheritance-expectations}
\alias{inheritance-expectations}
\alias{expect_type}
\alias{expect_s3_class}
\alias{expect_s4_class}
\title{Does code return an object inheriting from the expected base type, S3 class,
or S4 class?}
\usage{
expect_type(object, type)

expect_s3_class(object, class, exact = FALSE)

expect_s4_class(object, class)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{type}{String giving base type (as returned by \code{\link[=typeof]{typeof()}}).}

\item{class}{Either a character vector of class names, or
for \code{expect_s3_class()} and \code{expect_s4_class()}, an \code{NA} to assert
that \code{object} isn't an S3 or S4 object.}

\item{exact}{If \code{FALSE}, the default, checks that \code{object} inherits
from \code{class}. If \code{TRUE}, checks that object has a class that's identical
to \code{class}.}
}
\description{
See \url{https://adv-r.hadley.nz/oo.html} for an overview of R's OO systems, and
the vocabulary used here.
\itemize{
\item \code{expect_type(x, type)} checks that \code{typeof(x)} is \code{type}.
\item \code{expect_s3_class(x, class)} checks that \code{x} is an S3 object that
\code{\link[=inherits]{inherits()}} from \code{class}
\item \code{expect_s3_class(x, NA)} checks that \code{x} isn't an S3 object.
\item \code{expect_s4_class(x, class)} checks that \code{x} is an S4 object that
\code{\link[=is]{is()}} \code{class}.
\item \code{expect_s4_class(x, NA)} checks that \code{x} isn't an S4 object.
}

See \code{\link[=expect_vector]{expect_vector()}} for testing properties of objects created by vctrs.
}
\examples{
x <- data.frame(x = 1:10, y = "x", stringsAsFactors = TRUE)
# A data frame is an S3 object with class data.frame
expect_s3_class(x, "data.frame")
show_failure(expect_s4_class(x, "data.frame"))
# A data frame is built from a list:
expect_type(x, "list")

# An integer vector is an atomic vector of type "integer"
expect_type(x$x, "integer")
# It is not an S3 object
show_failure(expect_s3_class(x$x, "integer"))

# Above, we requested data.frame() converts strings to factors:
show_failure(expect_type(x$y, "character"))
expect_s3_class(x$y, "factor")
expect_type(x$y, "integer")
}
\seealso{
Other expectations: 
\code{\link{comparison-expectations}},
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{logical-expectations}}
}
\concept{expectations}
