% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-directory.R
\name{test_dir}
\alias{test_dir}
\alias{test_package}
\alias{test_check}
\alias{is_testing}
\title{Run all tests in directory or package}
\usage{
test_dir(path, filter = NULL, reporter = default_reporter(),
  env = test_env(), ..., encoding = "unknown", load_helpers = TRUE,
  stop_on_failure = FALSE, stop_on_warning = FALSE, wrap = TRUE)

test_package(package, filter = NULL, reporter = check_repoter(), ...,
  stop_on_failure = TRUE, stop_on_warning = FALSE)

test_check(package, filter = NULL, reporter = check_repoter(), ...,
  stop_on_failure = TRUE, stop_on_warning = FALSE, wrap = TRUE)

is_testing()
}
\arguments{
\item{path}{path to tests}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed.  Matching will take on the file
name after it has been stripped of \code{"test-"} and \code{".R"}.}

\item{reporter}{reporter to use}

\item{env}{environment in which to execute the tests}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}} to control filtering.}

\item{encoding}{File encoding, default is "unknown"
\code{unknown}.}

\item{load_helpers}{Source helper files before running the tests?}

\item{stop_on_failure}{If \code{TRUE}, throw an error if any tests fail.}

\item{stop_on_warning}{If \code{TRUE}, throw an error if any tests generate
warnings.}

\item{wrap}{Automatically wrap all code within \code{\link[=test_that]{test_that()}}? This ensures
that all expectations are reported, even if outside a test block.}

\item{package}{package name}
}
\value{
The results of the reporter function on all test results.

The results as a "testthat_results" (list)
}
\description{
Use \code{test_dir()} for a collection of tests in a directory; use
\code{test_package()} interactively at the console, and \code{test_check()}
inside of \code{R CMD check}.

In your own code, you can use \code{is_testing()} to determine if code is being
run as part of a test. You can also check the underlying env var directly
\code{identical(Sys.getenv("TESTTHAT"), "true")} to avoid creating a run-time
dependency on testthat.
}
\section{Test files}{

For package code, tests should live in \code{tests/testthat}.

There are four classes of \code{.R} files that have special behaviour:
\itemize{
\item Test files start with \code{test} and are executed in alphabetical order.
\item Helper files start with \code{helper} and are executed before tests are
run and from \code{devtools::load_all()}.
\item Setup files start with \code{setup} and are executed before tests, but not
during \code{devtools::load_all()}.
\item Teardown files start with \code{teardown} and are executed after the tests
are run.
}
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment that inherits from the
package's namespace environment, so that tests can access internal functions
and objects.
}

\section{\code{R CMD check}}{

To run testthat automatically from \code{R CMD check}, make sure you have
a \code{tests/testthat.R} that contains:\preformatted{library(testthat)
library(yourpackage)

test_check("yourpackage")
}
}

\examples{
\dontrun{test_package("testthat")}
}
