% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat.R
\name{test_examples_as_testthat}
\alias{test_examples_as_testthat}
\title{Execute examples from Rd files as \code{testthat} tests}
\usage{
test_examples_as_testthat(
  package,
  path,
  ...,
  test_dir = file.path(tempdir(), "testex-tests"),
  clean = TRUE,
  overwrite = TRUE,
  roxygenize = !is_r_cmd_check() && uses_roxygen2(path),
  reporter = testthat::get_reporter()
)
}
\arguments{
\item{package}{A package name whose examples should be tested}

\item{path}{Optionally, a path to a source code directory to use. Will only
have an effect if parameter \code{package} is missing.}

\item{...}{Additional argument unused}

\item{test_dir}{An option directory where test files should be written.
Defaults to a temporary directory.}

\item{clean}{Whether the \code{test_dir} should be removed upon completion of test
execution. Defaults to \code{TRUE}.}

\item{overwrite}{Whether files should be overwritten if \code{test_dir} already
exists. Defaults to \code{TRUE}.}

\item{roxygenize}{Whether R documentation files should be re-written using
\code{roxygen2} prior to testing. When not \code{FALSE}, tests written in \code{roxygen2}
tags will be used to update R documentation files prior to testing to use
the most up-to-date example tests. May be \code{TRUE}, or a \code{list} of arguments
passed to \code{\link[roxygen2:roxygenize]{roxygen2::roxygenize}}. By default, only enabled when running
outside of \verb{R CMD check} and while taking \code{roxygen2} as a dependency.}

\item{reporter}{A \code{testthat} reporter to use. Defaults to the active
reporter in the \code{testthat} environment or default reporter.}
}
\value{
The result of \code{\link[testthat:source_file]{testthat::source_file()}}, after iterating over
generated test files.
}
\description{
Reads examples from Rd files and constructs \code{testthat}-style tests.
\code{testthat} expectations are built such that
}
\details{
\enumerate{
\item Each example expression is expected to run without error
\item Any \code{testex} expectations are expected to pass
}

Generally, you won't need to use this function directly. Instead, it
is called by a file generated by \code{\link[=use_testex_as_testthat]{use_testex_as_testthat()}} which will add
any \code{testex} example tests to your existing \code{testthat} testing suite.
}
\note{
It is assumed that this function is used within a \code{testthat} run, when
the necessary packages are already installed and loaded.
}
\examples{
\dontshow{if (requireNamespace("testthat", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# library(pkg.example)
path <- system.file("pkg.example", package = "testex")
test_examples_as_testthat(path = path)
}
\dontshow{\}) # examplesIf}
}
