% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{getDelaunaySimplicies}
\alias{getDelaunaySimplicies}
\title{Delaunay simplicies}
\usage{
getDelaunaySimplicies(tessellation, hashes = FALSE)
}
\arguments{
\item{tessellation}{the output of \code{\link{delaunay}}}

\item{hashes}{Boolean, whether to return the simplicies as hash maps}
}
\value{
The list of simplicies of the Delaunay tessellation.
}
\description{
Get Delaunay simplicies (tiles).
}
\examples{
library(tessellation)
pts <- rbind(
  c(-5, -5,  16),
  c(-5,  8,   3),
  c(4,  -1,   3),
  c(4,  -5,   7),
  c(4,  -1, -10),
  c(4,  -5, -10),
  c(-5,  8, -10),
  c(-5, -5, -10)
)
tess <- delaunay(pts)
getDelaunaySimplicies(tess)
}
