% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bland_altman.R
\name{s_bland_altman}
\alias{s_bland_altman}
\title{Bland-Altman analysis}
\usage{
s_bland_altman(x, y, conf_level = 0.95)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{y}{(\code{numeric})\cr vector of numbers we want to analyze, to be compared with \code{x}.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A named list of the following elements:
\itemize{
\item \code{df}
\item \code{difference_mean}
\item \code{ci_mean}
\item \code{difference_sd}
\item \code{difference_se}
\item \code{upper_agreement_limit}
\item \code{lower_agreement_limit}
\item \code{agreement_limit_se}
\item \code{upper_agreement_limit_ci}
\item \code{lower_agreement_limit_ci}
\item \code{t_value}
\item \code{n}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Statistics function that uses the Bland-Altman method to assess the agreement between two numerical vectors
and calculates a variety of statistics.
}
\examples{
x <- seq(1, 60, 5)
y <- seq(5, 50, 4)

s_bland_altman(x, y, conf_level = 0.9)

}
