% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_km.R
\name{h_ggkm}
\alias{h_ggkm}
\title{Helper function to create a KM plot}
\usage{
h_ggkm(
  data,
  xticks = NULL,
  yval = "Survival",
  censor_show,
  xlab,
  ylab,
  ylim = NULL,
  title,
  footnotes = NULL,
  max_time = NULL,
  lwd = 1,
  lty = NULL,
  pch = 3,
  size = 2,
  col = NULL,
  ci_ribbon = FALSE,
  ggtheme = nestcolor::theme_nest()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr survival data as pre-processed by \code{h_data_plot}.}

\item{xticks}{(\code{numeric} or \code{NULL})\cr numeric vector of tick positions or a single number with spacing
between ticks on the x-axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
optimal tick positions on the x-axis.}

\item{yval}{(\code{string})\cr type of plot, to be plotted on the y-axis. Options are \code{Survival} (default) and \code{Failure}
probability.}

\item{censor_show}{(\code{flag})\cr whether to show censored observations.}

\item{xlab}{(\code{string})\cr x-axis label.}

\item{ylab}{(\code{string})\cr y-axis label.}

\item{ylim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the y-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{title}{(\code{string})\cr plot title.}

\item{footnotes}{(\code{string})\cr plot footnotes.}

\item{max_time}{(\code{numeric(1)})\cr maximum value to show on x-axis. Only data values less than or up to
this threshold value will be plotted (defaults to \code{NULL}).}

\item{lwd}{(\code{numeric})\cr line width. If a vector is given, its length should be equal to the number of strata from
\code{\link[survival:survfit]{survival::survfit()}}.}

\item{lty}{(\code{numeric})\cr line type. If a vector is given, its length should be equal to the number of strata from
\code{\link[survival:survfit]{survival::survfit()}}.}

\item{pch}{(\code{string})\cr name of symbol or character to use as point symbol to indicate censored cases.}

\item{size}{(\code{numeric(1)})\cr size of censored point symbols.}

\item{col}{(\code{character})\cr lines colors. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{ci_ribbon}{(\code{flag})\cr whether the confidence interval should be drawn around the Kaplan-Meier curve.}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to format the Kaplan-Meier plot.}
}
\value{
A \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Draw the Kaplan-Meier plot using \code{ggplot2}.
}
\examples{
\donttest{
library(dplyr)
library(survival)

fit_km <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  survfit(formula = Surv(AVAL, 1 - CNSR) ~ ARMCD, data = .)
data_plot <- h_data_plot(fit_km = fit_km)
xticks <- h_xticks(data = data_plot)
gg <- h_ggkm(
  data = data_plot,
  censor_show = TRUE,
  xticks = xticks,
  xlab = "Days",
  yval = "Survival",
  ylab = "Survival Probability",
  title = "Survival"
)
gg
}

}
