% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_lineplot.R
\name{g_lineplot}
\alias{g_lineplot}
\title{Line plot with optional table}
\usage{
g_lineplot(
  df,
  alt_counts_df = NULL,
  variables = control_lineplot_vars(),
  mid = "mean",
  interval = "mean_ci",
  whiskers = c("mean_ci_lwr", "mean_ci_upr"),
  table = NULL,
  sfun = s_summary,
  ...,
  mid_type = "pl",
  mid_point_size = 2,
  position = ggplot2::position_dodge(width = 0.4),
  legend_title = NULL,
  legend_position = "bottom",
  ggtheme = nestcolor::theme_nest(),
  xticks = NULL,
  xlim = NULL,
  ylim = NULL,
  x_lab = obj_label(df[[variables[["x"]]]]),
  y_lab = NULL,
  y_lab_add_paramcd = TRUE,
  y_lab_add_unit = TRUE,
  title = "Plot of Mean and 95\% Confidence Limits by Visit",
  subtitle = "",
  subtitle_add_paramcd = TRUE,
  subtitle_add_unit = TRUE,
  caption = NULL,
  table_format = NULL,
  table_labels = NULL,
  table_font_size = 3,
  errorbar_width = 0.45,
  newpage = lifecycle::deprecated(),
  col = NULL,
  linetype = NULL,
  rel_height_plot = 0.5,
  as_list = FALSE
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{alt_counts_df}{(\code{data.frame} or \code{NULL})\cr data set that will be used (only)
to counts objects in groups for stratification.}

\item{variables}{(named \code{character}) vector of variable names in \code{df} which should include:
\itemize{
\item \code{x} (\code{string})\cr name of x-axis variable.
\item \code{y} (\code{string})\cr name of y-axis variable.
\item \code{group_var} (\code{string} or \code{NULL})\cr name of grouping variable (or strata), i.e. treatment arm.
Can be \code{NA} to indicate lack of groups.
\item \code{subject_var} (\code{string} or \code{NULL})\cr name of subject variable. Only applies if \code{group_var} is
not NULL.
\item \code{paramcd} (\code{string} or \code{NA})\cr name of the variable for parameter's code. Used for y-axis label and plot's
subtitle. Can be \code{NA} if \code{paramcd} is not to be added to the y-axis label or subtitle.
\item \code{y_unit} (\code{string} or \code{NA})\cr name of variable with units of \code{y}. Used for y-axis label and plot's subtitle.
Can be \code{NA} if y unit is not to be added to the y-axis label or subtitle.
\item \code{facet_var} (\code{string} or \code{NA})\cr name of the secondary grouping variable used for plot faceting, i.e. treatment
arm. Can be \code{NA} to indicate lack of groups.
}}

\item{mid}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as midpoints.
All the statistics indicated in \code{mid} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length one.}

\item{interval}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as intervals.
All the statistics indicated in \code{interval} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length two. Set \code{interval = NULL} if intervals should not be
added to the plot.}

\item{whiskers}{(\code{character})\cr names of the interval whiskers that will be plotted. Names must match names
of the list element \code{interval} that will be returned by \code{sfun} (e.g. \code{mean_ci_lwr} element of
\code{sfun(x)[["mean_ci"]]}). It is possible to specify one whisker only, or to suppress all whiskers by setting
\code{interval = NULL}.}

\item{table}{(\code{character} or \code{NULL})\cr names of the statistics that will be displayed in the table below the plot.
All the statistics indicated in \code{table} variable must be present in the object returned by \code{sfun}.}

\item{sfun}{(\code{function})\cr the function to compute the values of required statistics. It must return a named \code{list}
with atomic vectors. The names of the \code{list} elements refer to the names of the statistics and are used by \code{mid},
\code{interval}, \code{table}. It must be able to accept as input a vector with data for which statistics are computed.}

\item{...}{optional arguments to \code{sfun}.}

\item{mid_type}{(\code{string})\cr controls the type of the \code{mid} plot, it can be point (\code{"p"}), line (\code{"l"}),
or point and line (\code{"pl"}).}

\item{mid_point_size}{(\code{numeric(1)})\cr font size of the \code{mid} plot points.}

\item{position}{(\code{character} or \code{call})\cr geom element position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{legend_title}{(\code{string})\cr legend title.}

\item{legend_position}{(\code{string})\cr the position of the plot legend (\code{"none"}, \code{"left"}, \code{"right"}, \code{"bottom"},
\code{"top"}, or a two-element numeric vector).}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control styling of the plot.}

\item{xticks}{(\code{numeric} or \code{NULL})\cr numeric vector of tick positions or a single number with spacing
between ticks on the x-axis, for use when \code{variables$x} is numeric. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is
used to determine optimal tick positions on the x-axis. If \code{variables$x} is not numeric, this argument is ignored.}

\item{xlim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the x-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{ylim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the y-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{x_lab}{(\code{string} or \code{NULL})\cr x-axis label. If \code{NULL} then no label will be added.}

\item{y_lab}{(\code{string} or \code{NULL})\cr y-axis label. If \code{NULL} then no label will be added.}

\item{y_lab_add_paramcd}{(\code{flag})\cr whether \code{paramcd}, i.e. \code{unique(df[[variables["paramcd"]]])} should be added
to the y-axis label (\code{y_lab}).}

\item{y_lab_add_unit}{(\code{flag})\cr whether y-axis unit, i.e. \code{unique(df[[variables["y_unit"]]])} should be added
to the y-axis label (\code{y_lab}).}

\item{title}{(\code{string})\cr plot title.}

\item{subtitle}{(\code{string})\cr plot subtitle.}

\item{subtitle_add_paramcd}{(\code{flag})\cr whether \code{paramcd}, i.e. \code{unique(df[[variables["paramcd"]]])} should be
added to the plot's subtitle (\code{subtitle}).}

\item{subtitle_add_unit}{(\code{flag})\cr whether the y-axis unit, i.e. \code{unique(df[[variables["y_unit"]]])} should be
added to the plot's subtitle (\code{subtitle}).}

\item{caption}{(\code{string})\cr optional caption below the plot.}

\item{table_format}{(named \code{character} or \code{NULL})\cr format patterns for descriptive statistics used in the
(optional) table appended to the plot. It is passed directly to the \code{h_format_row} function through the \code{format}
parameter. Names of \code{table_format} must match the names of statistics returned by \code{sfun} function.}

\item{table_labels}{(named \code{character} or \code{NULL})\cr labels for descriptive statistics used in the (optional) table
appended to the plot. Names of \code{table_labels} must match the names of statistics returned by \code{sfun} function.}

\item{table_font_size}{(\code{numeric(1)})\cr font size of the text in the table.}

\item{errorbar_width}{(\code{numeric(1)})\cr width of the error bars.}

\item{newpage}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} not used.}

\item{col}{(\code{character})\cr color(s). See \code{?ggplot2::aes_colour_fill_alpha} for example values.}

\item{linetype}{(\code{character})\cr line type(s). See \code{?ggplot2::aes_linetype_size_shape} for example values.}

\item{rel_height_plot}{(\code{proportion})\cr proportion of total figure height to allocate to the line plot.
Relative height of annotation table is then \code{1 - rel_height_plot}. If \code{table = NULL}, this parameter is ignored.}

\item{as_list}{(\code{flag})\cr whether the two \code{ggplot} objects should be returned as a list when \code{table} is not \code{NULL}.
If \code{TRUE}, a named list with two elements, \code{plot} and \code{table}, will be returned. If \code{FALSE} (default) the
annotation table is printed below the plot via \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}.}
}
\value{
A \code{ggplot} line plot (and statistics table if applicable).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Line plot with optional table.
}
\examples{

adsl <- tern_ex_adsl
adlb <- tern_ex_adlb \%>\% dplyr::filter(ANL01FL == "Y", PARAMCD == "ALT", AVISIT != "SCREENING")
adlb$AVISIT <- droplevels(adlb$AVISIT)
adlb <- dplyr::mutate(adlb, AVISIT = forcats::fct_reorder(AVISIT, AVISITN, min))

# Mean with CI
g_lineplot(adlb, adsl, subtitle = "Laboratory Test:")

# Mean with CI, no stratification with group_var
g_lineplot(adlb, variables = control_lineplot_vars(group_var = NA))

# Mean, upper whisker of CI, no group_var(strata) counts N
g_lineplot(
  adlb,
  whiskers = "mean_ci_upr",
  title = "Plot of Mean and Upper 95\% Confidence Limit by Visit"
)

# Median with CI
g_lineplot(
  adlb,
  adsl,
  mid = "median",
  interval = "median_ci",
  whiskers = c("median_ci_lwr", "median_ci_upr"),
  title = "Plot of Median and 95\% Confidence Limits by Visit"
)

# Mean, +/- SD
g_lineplot(adlb, adsl,
  interval = "mean_sdi",
  whiskers = c("mean_sdi_lwr", "mean_sdi_upr"),
  title = "Plot of Median +/- SD by Visit"
)

# Mean with CI plot with stats table
g_lineplot(adlb, adsl, table = c("n", "mean", "mean_ci"))

# Mean with CI, table and customized confidence level
g_lineplot(
  adlb,
  adsl,
  table = c("n", "mean", "mean_ci"),
  control = control_analyze_vars(conf_level = 0.80),
  title = "Plot of Mean and 80\% Confidence Limits by Visit"
)

# Mean with CI, table, filtered data
adlb_f <- dplyr::filter(adlb, ARMCD != "ARM A" | AVISIT == "BASELINE")
g_lineplot(adlb_f, table = c("n", "mean"))

}
