% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio.R
\name{h_odds_ratio}
\alias{h_odds_ratio}
\alias{or_glm}
\alias{or_clogit}
\title{Helper functions for odds ratio estimation}
\usage{
or_glm(data, conf_level)

or_clogit(data, conf_level)
}
\arguments{
\item{data}{(\code{data.frame})\cr data frame containing at least the variables \code{rsp} and \code{grp}, and optionally
\code{strata} for \code{\link[=or_clogit]{or_clogit()}}.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A named \code{list} of elements \code{or_ci} and \code{n_tot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Functions to calculate odds ratios in \code{\link[=estimate_odds_ratio]{estimate_odds_ratio()}}.
}
\section{Functions}{
\itemize{
\item \code{or_glm()}: Estimates the odds ratio based on \code{\link[stats:glm]{stats::glm()}}. Note that there must be
exactly 2 groups in \code{data} as specified by the \code{grp} variable.

\item \code{or_clogit()}: Estimates the odds ratio based on \code{\link[survival:clogit]{survival::clogit()}}. This is done for
the whole data set including all groups, since the results are not the same as when doing
pairwise comparisons between the groups.

}}
\examples{
# Data with 2 groups.
data <- data.frame(
  rsp = as.logical(c(1, 1, 0, 1, 0, 0, 1, 1)),
  grp = letters[c(1, 1, 1, 2, 2, 2, 1, 2)],
  strata = letters[c(1, 2, 1, 2, 2, 2, 1, 2)],
  stringsAsFactors = TRUE
)

# Odds ratio based on glm.
or_glm(data, conf_level = 0.95)

# Data with 3 groups.
data <- data.frame(
  rsp = as.logical(c(1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0)),
  grp = letters[c(1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3)],
  strata = LETTERS[c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2)],
  stringsAsFactors = TRUE
)

# Odds ratio based on stratified estimation by conditional logistic regression.
or_clogit(data, conf_level = 0.95)

}
\seealso{
\link{odds_ratio}
}
