% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_survival_step.R
\name{fit_survival_step}
\alias{fit_survival_step}
\title{Subgroup Treatment Effect Pattern (STEP) Fit for Survival Outcome}
\usage{
fit_survival_step(
  variables,
  data,
  control = c(control_step(), control_coxph())
)
}
\arguments{
\item{variables}{(named \code{list} of \code{character})\cr list of analysis variables: needs \code{time}, \code{event},
\code{arm}, \code{biomarker}, and optional \code{covariates} and \code{strata}.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{control}{(named \code{list})\cr combined control list from \code{\link[=control_step]{control_step()}} and \code{\link[=control_coxph]{control_coxph()}}.}
}
\value{
A matrix of class \code{step}. The first part of the columns describe the subgroup intervals used
for the biomarker variable, including where the center of the intervals are and their bounds. The
second part of the columns contain the estimates for the treatment arm comparison.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This fits the Subgroup Treatment Effect Pattern models for a survival outcome. The treatment arm
variable must have exactly 2 levels, where the first one is taken as reference and the estimated
hazard ratios are for the comparison of the second level vs. the first one.

The model which is fit is:

\code{Surv(time, event) ~ arm * poly(biomarker, degree) + covariates + strata(strata)}

where \code{degree} is specified by \code{control_step()}.
}
\note{
For the default degree 0 the \code{biomarker} variable is not included in the model.
}
\examples{
# Testing dataset with just two treatment arms.
library(dplyr)

adtte_f <- tern_ex_adtte \%>\%
  filter(
    PARAMCD == "OS",
    ARM \%in\% c("B: Placebo", "A: Drug X")
  ) \%>\%
  mutate(
    # Reorder levels of ARM to display reference arm before treatment arm.
    ARM = droplevels(forcats::fct_relevel(ARM, "B: Placebo")),
    is_event = CNSR == 0
  )
labels <- c("ARM" = "Treatment Arm", "is_event" = "Event Flag")
formatters::var_labels(adtte_f)[names(labels)] <- labels

variables <- list(
  arm = "ARM",
  biomarker = "BMRKR1",
  covariates = c("AGE", "BMRKR2"),
  event = "is_event",
  time = "AVAL"
)

# Fit default STEP models: Here a constant treatment effect is estimated in each subgroup.
step_matrix <- fit_survival_step(
  variables = variables,
  data = adtte_f
)
dim(step_matrix)
head(step_matrix)

# Specify different polynomial degree for the biomarker interaction to use more flexible local
# models. Or specify different Cox regression options.
step_matrix2 <- fit_survival_step(
  variables = variables,
  data = adtte_f,
  control = c(control_coxph(conf_level = 0.9), control_step(degree = 2))
)

# Use a global model with cubic interaction and only 5 points.
step_matrix3 <- fit_survival_step(
  variables = variables,
  data = adtte_f,
  control = c(control_coxph(), control_step(bandwidth = NULL, degree = 3, num_points = 5L))
)

}
\seealso{
\code{\link[=control_step]{control_step()}} and \code{\link[=control_coxph]{control_coxph()}} for the available customization options.
}
