% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_patients_events_in_cols.R
\name{count_patients_events_in_cols}
\alias{count_patients_events_in_cols}
\alias{summarize_patients_events_in_cols}
\alias{s_count_patients_and_multiple_events}
\title{Counting Patients and Events in Columns}
\usage{
summarize_patients_events_in_cols(
  lyt,
  id = "USUBJID",
  filters_list = list(),
  empty_stats = character(),
  na_str = default_na_str(),
  ...,
  .stats = c("unique", "all", names(filters_list)),
  .labels = c(unique = "Patients (All)", all = "Events (All)",
    labels_or_names(filters_list)),
  col_split = TRUE
)

s_count_patients_and_multiple_events(
  df,
  id,
  filters_list,
  empty_stats = character(),
  labelstr = "",
  custom_label = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{id}{(\code{string})\cr subject variable name.}

\item{filters_list}{(named \code{list} of \code{character})\cr each element in this list describes one
type of event describe by filters, in the same format as \code{\link[=s_count_patients_with_event]{s_count_patients_with_event()}}.
If it has a label, then this will be used for the column title.}

\item{empty_stats}{(\code{character})\cr optional names of the statistics that should be returned empty such
that corresponding table cells will stay blank.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run
\code{get_stats("summarize_patients_events_in_cols")} to see available statistics for this function, in addition
to any added using \code{filters_list}.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{col_split}{(\code{flag})\cr whether the columns should be split.
Set to \code{FALSE} when the required column split has been done already earlier in the layout pipe.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{custom_label}{(\code{string} or \code{NULL})\cr if provided and \code{labelstr} is empty then this will
be used as label.}
}
\value{
\itemize{
\item \code{summarize_patients_events_in_cols()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted content rows
containing the statistics from \code{s_count_patients_and_multiple_events()} to the table layout.
}

\itemize{
\item \code{s_count_patients_and_multiple_events()} returns a list with the statistics:
\itemize{
\item \code{unique}: number of unique patients in \code{df}.
\item \code{all}: number of rows in \code{df}.
\item one element with the same name as in \code{filters_list}: number of rows in \code{df},
i.e. events, fulfilling the filter condition.
}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Counting the number of unique patients and the total number of all and specific events
when a column table layout is required.
}
\section{Functions}{
\itemize{
\item \code{summarize_patients_events_in_cols()}: Layout-creating function which can take statistics function
arguments and additional format arguments. This function is a wrapper for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{s_count_patients_and_multiple_events()}: Statistics function which counts numbers of patients and multiple
events defined by filters. Used as analysis function \code{afun} in \code{summarize_patients_events_in_cols()}.

}}
\examples{
df <- data.frame(
  USUBJID = rep(c("id1", "id2", "id3", "id4"), c(2, 3, 1, 1)),
  ARM = c("A", "A", "B", "B", "B", "B", "A"),
  AESER = rep("Y", 7),
  AESDTH = c("Y", "Y", "N", "Y", "Y", "N", "N"),
  AEREL = c("Y", "Y", "N", "Y", "Y", "N", "Y"),
  AEDECOD = c("A", "A", "A", "B", "B", "C", "D"),
  AEBODSYS = rep(c("SOC1", "SOC2", "SOC3"), c(3, 3, 1))
)

# `summarize_patients_events_in_cols()`
basic_table() \%>\%
  summarize_patients_events_in_cols(
    filters_list = list(
      related = formatters::with_label(c(AEREL = "Y"), "Events (Related)"),
      fatal = c(AESDTH = "Y"),
      fatal_related = c(AEREL = "Y", AESDTH = "Y")
    ),
    custom_label = "\%s Total number of patients and events"
  ) \%>\%
  build_table(df)

}
\keyword{internal}
