% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_factor.R
\name{fct_explicit_na_if}
\alias{fct_explicit_na_if}
\title{Insertion of Explicit Missings in a Factor}
\usage{
fct_explicit_na_if(x, condition, na_level = "<Missing>")
}
\arguments{
\item{x}{(\code{factor})\cr the original factor.}

\item{condition}{(\code{logical})\cr where to insert missings.}

\item{na_level}{(\code{string})\cr which level to use for missings.}
}
\value{
A modified \code{factor} with inserted and existing \code{NA} converted to \code{na_level}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This inserts explicit missings in a factor based on a condition. Additionally,
existing \code{NA} values will be explicitly converted to given \code{na_level}.
}
\examples{
fct_explicit_na_if(factor(c("a", "b", NA)), c(TRUE, FALSE, FALSE))

}
\seealso{
\code{\link[forcats:fct_na_value_to_level]{forcats::fct_na_value_to_level()}} which is used internally.
}
