% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.tergm.R
\name{simulate.tergm}
\alias{simulate.tergm}
\alias{simulate_formula.network}
\alias{simulate_formula.networkDynamic}
\title{Draw from the distribution of a Temporal Exponential Family
Random Graph Model}
\usage{
\method{simulate}{tergm}(
  object,
  nsim = 1,
  seed = NULL,
  coef = coefficients(object),
  constraints = object$constraints,
  monitor = object$targets,
  time.slices = 1,
  time.start = NULL,
  time.burnin = 0,
  time.interval = 1,
  control = control.simulate.tergm(),
  output = c("networkDynamic", "stats", "changes", "final", "ergm_state"),
  nw.start = NULL,
  stats = FALSE,
  verbose = FALSE,
  ...
)

\method{simulate_formula}{network}(
  object,
  nsim = 1,
  seed = NULL,
  coef = NULL,
  constraints = ~.,
  monitor = NULL,
  time.slices = 1,
  time.start = NULL,
  time.burnin = 0,
  time.interval = 1,
  time.offset = 1,
  control = control.simulate.formula.tergm(),
  output = c("networkDynamic", "stats", "changes", "final", "ergm_state"),
  stats = FALSE,
  verbose = FALSE,
  ...,
  basis = ergm.getnetwork(object),
  dynamic = FALSE
)

\method{simulate_formula}{networkDynamic}(
  object,
  nsim = 1,
  seed = NULL,
  coef = attr(basis, "coef"),
  constraints = ~.,
  monitor = NULL,
  time.slices = 1,
  time.start = NULL,
  time.burnin = 0,
  time.interval = 1,
  time.offset = 1,
  control = control.simulate.formula.tergm(),
  output = c("networkDynamic", "stats", "changes", "final", "ergm_state"),
  stats = FALSE,
  verbose = FALSE,
  ...,
  basis = eval_lhs.formula(object),
  dynamic = FALSE
)
}
\arguments{
\item{object}{for \code{simulate.tergm}, an object of type \code{\link{tergm}} giving a model fit;
for \code{simulate_formula.network} and \code{simulate_formula.networkDynamic}, a formula specifying
the model

\code{simulate_formula.network} understands the \code{\link{lasttoggle}} "API".}

\item{nsim}{Number of replications (separate chains of networks) of the
process to run and return. The \code{\link{networkDynamic}} method only
supports \code{nsim=1}.}

\item{seed}{Random number integer seed.  See \code{\link[base]{set.seed}}.}

\item{coef}{Parameters for the model.}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being modeled. Multiple constraints may be given,
separated by \dQuote{+} operators.  Together with the model terms in the
formula and the reference measure, the constraints define the distribution
of networks being modeled.

The default is \code{~.}, for an unconstrained model.

See the \link[=ergm-constraints]{ERGM constraints} documentation for the
constraints implemented in the \strong{\link[=ergm-package]{ergm}} package.
Other packages may add their own constraints.

Note that not all possible combinations of constraints are supported.}

\item{monitor}{A one-sided formula specifying one or more terms whose
value is to be monitored.  If \code{monitor} is specified as a character
(one of \code{"formation"}, \code{"dissolution"}, and \code{"all"}) then
the function \code{\link{.extract.fd.formulae}} is used to determine the
corresponding formula; the user should be aware of its behavior and limitations.}

\item{time.slices}{Number of time slices (or statistics) to return from each
replication of the dynamic process. See below for return types. Defaults to
1, which, if \code{time.burnin==0} and \code{time.interval==1} (the
defaults), advances the process one time step.}

\item{time.start}{An optional argument specifying the time point at which
the simulation is to start. See Details for further information.}

\item{time.burnin}{Number of time steps to discard before starting to
collect network statistics.}

\item{time.interval}{Number of time steps between successive recordings of
network statistics.}

\item{control}{A list of control parameters for algorithm tuning.
Constructed using \code{\link{control.simulate.tergm}} or
\code{\link{control.simulate.formula.tergm}}.  For backwards compatibility,
control lists from \code{\link{control.simulate.stergm}} and
\code{\link{control.simulate.network}} are allowed in calls to
\code{simulate.tergm}; they are mapped to \code{control.simulate.tergm}
by assigning:
\itemize{
\item \code{MCMC.prop.form} to \code{MCMC.prop},
\item \code{MCMC.prop.args.form} to \code{MCMC.prop.args},
\item \code{MCMC.prop.weights.form} to \code{MCMC.prop.weights}.
}}

\item{output}{A character vector specifying output type: one of
\code{"networkDynamic"} (the default), \code{"stats"}, \code{"changes"}, \code{"final"}, and
\code{"ergm_state"}, with partial matching allowed. See Value section for details.}

\item{nw.start}{A specification for the starting network to be used by
\code{simulate.tergm}, optional for EGMME fits, but required for CMLE and
CMPLE fits: \describe{ \item{a numeric index \code{i}}{use \code{i}th time-point's
network, where the first network in the series used to fit the model is
defined to be at the first time point;}
\item{\code{"first"} or \code{"last"}}{the first or last time point used in
fitting the model; or}
\item{\code{network}}{specify the network directly.}
}
\code{\link{networkDynamic}}s
cannot be used as starting networks for \code{simulate.tergm} at this time.
(They can be used as starting networks for \code{simulate_formula.networkDynamic},
of course.)}

\item{stats}{Logical: Whether to return
model statistics. This is not the recommended method:
use \code{monitor} argument instead.}

\item{verbose}{Logical: If TRUE, extra information is printed as the Markov
chain progresses.}

\item{\dots}{Further arguments passed to or used by methods.}

\item{time.offset}{Argument specifying the offset between the point when the
state of the network is sampled (\code{time.start}) and the the beginning of
the spell that should be recorded for the newly simulated network state.}

\item{basis}{For the \code{network} and \code{networkDynamic} methods,
the network to start the simulation from.  (If \code{basis} is missing,
the default is the left hand side of the \code{object} argument.)}

\item{dynamic}{Logical; if \code{TRUE}, dynamic simulation is performed in
\code{tergm}; if \code{FALSE} (the default), ordinary \code{ergm}
simulation is performed instead.  Note that when \code{dynamic=FALSE},
default argument values for \code{ergm}'s \code{simulate} methods
are used.}
}
\value{
Depends on the \code{output} argument:
\item{"stats"}{If \code{stats == FALSE}, an \code{\link{mcmc}} matrix with
monitored statistics, and if \code{stats == TRUE}, a
list containing elements \code{stats} for statistics specified in the
\code{monitor} argument, and \code{stats.gen} for the model statistics.
If \code{stats == FALSE} and no monitored statistics are specified,
an empty list is returned, with a warning.
When \code{nsim>1}, an \code{\link{mcmc.list}} (or list of them) of
the statistics is returned instead.}
\item{"networkDynamic"}{A \code{\link[networkDynamic]{networkDynamic}}
object representing the simulated process, with ties present in the
initial network having onset \code{-Inf} and ties present at the end
of the simulation having terminus \code{+Inf}. The method for
\code{\link[networkDynamic]{networkDynamic}} returns the initial
\code{\link[networkDynamic]{networkDynamic}} with simulated changes
applied to it. The \code{\link{net.obs.period}} network attribute is
updated (or added if not existing) to reflect the time period that was
simulated. If the network does not have any \code{\link[networkDynamic]{persistent.ids}}
defined for vertices, a vertex.pid will be attached in a vertex attribute
named \code{'tergm_pid'} to facilitate 'bookkeeping' between the networkDynamic
argument and the simulated network time step.
Additionally, attributes (\code{\link{attr}}, not network
attributes) are attached as follows:
\describe{
\item{\code{formula}, \code{monitor}:}{Model
and monitoring formulas used in the simulation, respectively.}
\item{\code{stats}, \code{stats.gen}:}{Network statistics as above.}
\item{\code{coef}:}{Coefficients used in the simulation.}
\item{\code{changes}:}{A four-column matrix summarizing the changes in the
\code{"changes"} output. (This may be removed in the future.)}
}
When \code{nsim>1}, a \code{\link{network.list}} of these
\code{\link{networkDynamic}}s is returned.
}

\item{"changes"}{An integer matrix with four columns (\code{time},
\code{tail}, \code{head}, and \code{to}), giving the time-stamped
changes relative to the current network. \code{to} is \code{1} if
a tie was formed and \code{0} if a tie was dissolved. The
convention for \code{time} is that it gives the time point during
which the change is effective. For example, a row
\code{c(5,2,3,1)} indicates that between time \eqn{4} and \eqn{5},
a tie from node \eqn{2} to node \eqn{3} was formed, so that it was
absent at time point \eqn{4} and present at time point \eqn{5};
while a row \code{c(5,2,3,0)} indicates that in that time, that
tie was dissolved, so that it is was present at time point \eqn{4}
and absent at time point \eqn{5}.
Additionally, the same attributes (\code{\link{attr}}, not network
attributes) as with \code{output=="networkDynamic"} are attached.
When \code{nsim>1}, a list of these change matrices is returned.}
\item{"final"}{A \code{\link[network]{network}}
object representing the last network in the series generated.
\code{\link{lasttoggle}} and \code{time} attributes are also included.
Additionally, the same attributes (\code{\link{attr}}, not network
attributes) as with \code{output=="networkDynamic"} are attached.
When \code{nsim>1}, a \code{\link{network.list}} of these
\code{\link{network}}s is returned.
}
\item{"ergm_state"}{The \code{\link[ergm]{ergm_state}} object resulting
from the simulation.  Attributes are attached as for other output types.}
Note that when using \code{simulate_formula.networkDynamic} with either
\code{"final"} or \code{"ergm_state"} for \code{output}, the nodes
included in these objects are those produced by \code{network.collapse}
at the start time.
}
\description{
\code{\link[stats]{simulate}} is used to draw from temporal
exponential family random network models in their natural parameterizations.
See \code{\link{tergm}} for more information on these models.
}
\details{
The dynamic process is run forward and the results are returned. For the
method for \code{\link{networkDynamic}}, the simulation is resumed from the
last generated time point of \code{basis} (or the left hand side of \code{object}
if \code{basis} is missing), by default with the same model
and parameters.

The starting network for the \code{\link{tergm}} object method
(\code{simulate.tergm}) is determined by the \code{nw.start} argument.

\itemize{
\item{If \code{time.start} is specified, it is used as the initial
time index of the simulation.}
\item{If \code{time.start} is not specified (is \code{NULL}), then
if the \code{object} carries a time stamp from which to start
or resume the simulation, either in the form
of a \code{"time"} network attribute (for the
\code{\link{network}} method --- see the
\code{\link{lasttoggle}} "API") or
in the form of an \code{\link{net.obs.period}} network attribute (for the
\code{\link{networkDynamic}} method), this attribute will be used. (If
specified, \code{time.start} will override it with a warning.)
}
\item{Othewise, the simulation starts at 0.}
}
}
\examples{
\donttest{
data(samplk)

# Fit a transition from Time 1 to Time 2
samplk12 <- tergm(list(samplk1, samplk2)~
                  Form(~edges+mutual+transitiveties+cyclicalties)+
                  Diss(~edges+mutual+transitiveties+cyclicalties),
                  estimate="CMLE")

# direct simulation from tergm object
sim1 <- simulate(samplk12, nw.start="last")

# equivalent simulation from formula with network LHS;
# must pass dynamic=TRUE for tergm simulation
sim2 <- simulate(samplk2 ~ Form(~edges+mutual+transitiveties+cyclicalties) +
                           Diss(~edges+mutual+transitiveties+cyclicalties),
                           coef = coef(samplk12),
                           dynamic=TRUE)

# the default simulate output is a networkDynamic, and we can simulate
# with a networkDynamic LHS as well
sim3 <- simulate(sim2 ~ Form(~edges+mutual+transitiveties+cyclicalties) +
                        Diss(~edges+mutual+transitiveties+cyclicalties),
                        coef = coef(samplk12),
                        dynamic=TRUE)
}
}
