% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoCore.R
\name{tempo.run}
\alias{tempo.run}
\title{The main method.}
\usage{
tempo.run(X, Y, genesets, phen = NULL, ctrl = NULL, test = NULL,
  train = NULL, output = "", numPerms = 500, validation = "LOO",
  minGsSize = 2, nCores = 24, pCutoff = 0.05, fdrCutoff = 0.25,
  pMseCutoff = 0.05)
}
\arguments{
\item{X}{a matrix with sample ids as row names and gene ids as column names.}

\item{Y}{a list indexed by sample ids, containing numerical values.}

\item{genesets}{a list of lists.  Outer list is indexed by gene set name, inner list contains all gene ids in a given gene set}

\item{phen}{a list indexed by sample ids, containing phenotypes.  If ctrl and test are null, the phenotype of the first non-NA entry in the list is assumed to be the control phenotype; all others are test phenotypes}

\item{ctrl}{a list of sample ids.  The list of control samples to use in scoring.  If train is null, these are also the training samples.  Used only if phen is null.}

\item{test}{a list of sample ids.  The list of test samples to use in scoring.  Used only if phen is null.}

\item{train}{a list of sample ids.  The list of control samples to train models on.  If null, samples ids in ctrl are used. Used only if phen is null.}

\item{output}{optional.  A prefix to write table of output and plots for each reported gene set}

\item{numPerms}{number of permutations to do in permutation testing.  Defaults to 500}

\item{validation}{type of validation to do.  Defaults to leave one out, which generates deterministic results.  "CV" performs 10-fold cross-validation, which is significantly faster but generates non-deterministic results.}

\item{minGsSize}{minimum acceptable size for a gene set, considering only features which exist in \code{colnames(X)}}

\item{nCores}{number of thread to spawn for permutation testing.  This should likely be set to some number less than or equal to
the number of cores on your machine.  If nCores is less than 0, nCores will be set to the return value of \code{\link[parallel]{detectCores}}.}

\item{pCutoff}{report only gene sets with a p-value below this cutoff}

\item{fdrCutoff}{report only gene sets with a FDR below this cutoff}

\item{pMseCutoff}{report only gene sets with the p-value of the control mean squared error below this cutoff}
}
\value{
the output from \code{\link{tempo.runInstance}} annotated with significance for each gene set
}
\description{
For each gene set in genesets, train a model on the control samples of Y~X.  Generates scores for each gene set, performs permutation testing, and (optionally) writes a table of results and plots
}
\examples{
data("dflatExample")
data("gse32472Example")

\donttest{
# This runs a simple TEMPO analysis on the example data set with default settings
# (with the exception of nCores, which will instead be automatically set to a suitable
# value) and saves the output in a two temporary files.
# Note that running this example may take several minutes.
results = tempo.run(phen=gse32472Example$bpd,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age,
    output=tempfile(tmpdir = tempdir()),
    nCores=-1)

# If phen is used, the first item in the list is assumed to the control phenotype
# and all other phenotypes test. Specifiy ctrl and test exactly for more control.
# Note that running this example may take several minutes.
results = tempo.run(ctrl=gse32472Example$ctrl,
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age,
    nCores=-1)


# If training models on a held out set of data is desired, train can be specified seperately
# Note that running this example may take several minutes.
results2 = tempo.run(train=gse32472Example$ctrl[1:10],
    ctrl=gse32472Example$ctrl[11:20],
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age,
    nCores=-1)
}

# Reporting thresholds, number of permutations, and number of CPU cores used can all be changed.
# This command is suitable for demonstration purposes, but significance values will not be
# meaningful.
results3 = tempo.run(phen=gse32472Example$bpd,
    genesets=dflatExample,X=gse32472Example$data,
    Y=gse32472Example$age,output=tempfile(tmpdir = tempdir()),
    numPerms=2,nCores=2,pCutoff=1,fdrCutoff=2,pMseCutoff = 1)
}
