% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{interpol}
\alias{interpol}
\alias{interpol.SpatialPoints}
\alias{interpol.matrix}
\alias{interpol.data.frame}
\alias{interpol.t2d_tin}
\title{Interpolate from source to target locations}
\usage{
interpol(trg, src, ...)

\method{interpol}{SpatialPoints}(trg, src, ..., z, n = 5, output = "sp")

\method{interpol}{matrix}(trg, src, ..., n = 5, output = "numeric")

\method{interpol}{data.frame}(trg, src, ..., n = 5, output = "data.frame")

\method{interpol}{t2d_tin}(trg, src, ..., n = 5, output = "numeric")
}
\arguments{
\item{trg}{The target locations. Either: a \code{matrix} or \code{data.frame}
with x and y coordinates; an object of class \code{\link[sp]{SpatialPoints}};
an object of class \code{t2d_tin}.}

\item{src}{The source locations. Either: a \code{matrix} with x and y coordinates
(argument \code{z} as to be provided); a \code{data.frame} with x and y coordinates and
the variable of interest (\code{"z"}); an object of class \code{\link[sp]{SpatialPointsDataFrame}},
\code{\link[raster]{raster}}, or \href{https://r-spatial.github.io/stars/index.html}{stars}
(only the first attribute is taken).}

\item{...}{Further arguments passed to \code{\link[gstat]{idw}}.}

\item{z}{If \code{src} is a \code{matrix}: \code{numeric} vector of values at \code{src} locations to be interpolated
to \code{trg} locations.}

\item{n}{The number of nearest neighbours used for interpolation (default is 5).}

\item{output}{The type of output: \code{numeric}, \code{sp}, or \code{data.frame} (see below).}
}
\value{
\code{output = "numeric"}: a vector of values interpolated to \code{trg}
locations.

\code{output = "data.frame"}: a \code{data.frame} with x and y coordinates of \code{trg}
location and interpolated values ("z").

\code{output = "sp"}: an object of class \code{\link[sp]{SpatialPointsDataFrame}}
with the interpolated values at \code{trg} locations.
}
\description{
Interpolates values from source to target location using inverse distance weighting
(IDW) of nearest neighbours.
}
\details{
Function calls \code{\link[gstat]{idw}}. You can pass further arguments to
that function, e.g. \code{idp} to influence the distance-based weighting of neighbours
(default is 2).
}
