% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{+.TelegramObject}
\alias{+.TelegramObject}
\alias{add}
\title{Constructing an Updater}
\usage{
\method{+}{TelegramObject}(e1, e2)
}
\arguments{
\item{e1}{An object of class \code{\link{Updater}} or  \code{\link{Dispatcher}}.}

\item{e2}{An object of class \code{\link{Handler}}.}
}
\description{
With \code{+} you can add any kind of \code{\link{Handler}} to
    an \code{\link{Updater}}'s \code{Dispatcher} (or directly to a \code{\link{Dispatcher}}).
}
\details{
See \code{\link{add_handler}} for further information.
}
\examples{
\dontrun{
# You can chain multiple handlers
start <- function(bot, update){
  bot$sendMessage(chat_id = update$message$chat_id,
                  text = sprintf("Hello \%s!",
                                 update$message$from$first_name))
}
echo <- function(bot, update){
  bot$sendMessage(chat_id = update$message$chat_id,
                  text = update$message$text)
}

updater <- Updater("TOKEN") + CommandHandler("start", start) +
  MessageHandler(echo, MessageFilters$text)
  
# And keep adding...
caps <- function(bot, update, args){
  if (length(args > 0L)){
    text_caps <- toupper(paste(args, collapse = " "))
    bot$sendMessage(chat_id = update$message$chat_id,
                    text = text_caps) 
  }
}

updater <- updater + CommandHandler("caps", caps, pass_args = TRUE)

# Give it a try!
updater$start_polling()
# Send '/start' to the bot, '/caps foo' or just a simple text
}
}
