% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stVIF.R
\name{stVIF}
\alias{stVIF}
\title{Computes variance inflation factors for fixed effects of the teleconnection model}
\usage{
stVIF(stData, stFit, burn)
}
\arguments{
\item{stData}{Object with class 'stData' containing data needed to fit this 
model.}

\item{stFit}{Object with class 'stFit' containing posterior parameter samples
needed to composition sample the teleconnection effects and generate 
posterior predictions.}

\item{burn}{number of posterior samples to burn before drawing composition
samples}
}
\description{
VIFs will be computed at the posterior mean of all covariance parameters.
}
\examples{

data("coprecip")
data("coprecip.fit")

stVIF(stData = coprecip, stFit = coprecip.fit, burn = 50)

}
