% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{mean_resultant_length}
\alias{mean_resultant_length}
\title{Mean Resultant Length}
\usage{
mean_resultant_length(x, w = NULL, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees, for which the
mean, median or standard deviation are required.}

\item{w}{(optional) Weights. A vector of positive numbers, of the same length as
\code{x}.}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
numeric.
}
\description{
Measure of spread around the circle. It should be noted that:
If R=0, then the data is completely spread around the circle.
If R=1, the data is completely concentrated on one point.
}
\examples{
# Example data from Davis (1986), pp. 316
finland_stria <- c(
  23, 27, 53, 58, 64, 83, 85, 88, 93, 99, 100, 105, 113,
  113, 114, 117, 121, 123, 125, 126, 126, 126, 127, 127, 128, 128, 129, 132,
  132, 132, 134, 135, 137, 144, 145, 145, 146, 153, 155, 155, 155, 157, 163,
  165, 171, 172, 179, 181, 186, 190, 212
)
mean_resultant_length(finland_stria, w = NULL, na.rm = FALSE) # 0.800
}
\references{
Mardia, K.V. (1972). Statistics of Directional Data: Probability
and Mathematical Statistics. London: Academic Press.
}
