% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{PoR_coordinates}
\alias{PoR_coordinates}
\title{PoR coordinates}
\usage{
PoR_coordinates(x, PoR)
}
\arguments{
\item{x}{\code{sf} or \code{data.frame} containing lat and lon coordinates
(\code{lat}, \code{lon})}

\item{PoR}{Pole of Rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler pole}
}
\value{
\code{data.frame} with the PoR coordinates
(\code{lat.PoR}, \code{lon.PoR})
}
\description{
Retrieve the PoR equivalent coordinates of an object
}
\examples{
data("nuvel1")
por <- subset(nuvel1, nuvel1$plate.rot == "na") # North America relative to Pacific plate
data("san_andreas")
san_andreas.por_sf <- PoR_coordinates(san_andreas, por)
head(san_andreas.por_sf)
san_andreas.por_df <- PoR_coordinates(sf::st_drop_geometry(san_andreas), por)
head(san_andreas.por_df)
}
