% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_eulerpole.R
\name{stress_paths}
\alias{stress_paths}
\alias{eulerpole_paths}
\alias{eulerpole_smallcircles}
\alias{eulerpole_greatcircles}
\alias{eulerpole_loxodromes}
\title{Theoretical Plate Tectonic Stress Paths}
\usage{
eulerpole_paths(x, type = c("sc", "gc", "ld"), n = 10, angle, cw)

eulerpole_smallcircles(x, n = 10)

eulerpole_greatcircles(x, n = 10)

eulerpole_loxodromes(x, n = 10, angle = 45, cw)
}
\arguments{
\item{x}{Either an object of class \code{"euler.pole"} or \code{"data.frame"}
containing coordinates of Euler pole in lat, lon, and rotation angle
(optional).}

\item{type}{Character string specifying the type of curves to export. Either
\code{"sm"} for small circles (default), \code{"gc"} for great circles, or
\code{"ld"} for loxodromes.}

\item{n}{Number of equally spaced curves; \code{n = 10} by default (angular
distance between curves: \code{180 / n})}

\item{angle}{Direction of loxodromes; \code{angle = 45} by default.}

\item{cw}{logical. Sense of loxodromes: \code{TRUE} for clockwise
loxodromes (left-lateral displaced plate boundaries). \code{FALSE} for
counterclockwise loxodromes (right-lateral displaced plate boundaries).}
}
\value{
\code{sf} object
}
\description{
Construct \eqn{\sigma_{Hmax}}{SHmax} lines that are
following small circles, great circles, or loxodromes of an Euler pole for
the relative plate motion.
}
\details{
Maximum horizontal stress can be aligned to three types of curves
related to relative plate motion:
\describe{
\item{Small circles}{Lines that have a constant distance to the Euler pole.
If \code{x} contains \code{angle}, output additionally gives absolute
velocity on small circle (degree/Myr -> km/Myr).}
\item{Great circles}{Paths of the shortest distance between the Euler
pole and its antipodal position.}
\item{Loxodromes}{Lines of constant bearing, i.e. curves cutting small
circles at a constant angle.}
}
}
\examples{
data("nuvel1")
por <- subset(nuvel1, nuvel1$plate.rot == "na") # North America relative to
# Pacific plate

eulerpole_smallcircles(por)
eulerpole_greatcircles(por)
eulerpole_loxodromes(x = por, angle = 45, n = 10, cw = FALSE)
eulerpole_loxodromes(x = por, angle = 30, cw = TRUE)
eulerpole_smallcircles(data.frame(lat = 30, lon = 10))
}
\author{
Tobias Stephan
}
