% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{rose_baseplot}
\alias{rose_baseplot}
\title{Rose Diagram}
\usage{
rose_baseplot(
  start = -90,
  clockwise = TRUE,
  main = NULL,
  labels = TRUE,
  at = seq(0, 360 - 45, 45),
  cborder = TRUE,
  ...
)
}
\arguments{
\item{start}{The starting direction for measurement of angles, that is, the
spatial direction which corresponds to a measured angle of zero. Either a
character string giving a compass direction (\code{"N"} for north, \code{"S"} for south,
\code{"E"} for east, or \code{"W"} for west) or a number giving the angle from the the
horizontal (East) axis to the starting direction. For example, if
\code{clockwise=FALSE}, then \code{start=90} and \code{start="N"} are
equivalent. The default is to measure angles anti-clockwise from the
horizontal axis (East direction).}

\item{clockwise}{Logical. Whether angles increase in the
clockwise direction (\code{clockwise=TRUE}, the default) or anti-clockwise,
counter-clockwise direction (\code{FALSE}).}

\item{main}{Character string specifying the title of the plot.}

\item{labels}{Either a logical value indicating whether to plot labels
next to the tick marks, or a vector of labels for the tick marks.}

\item{at}{Optional vector of angles at which tick marks should be plotted.
Set \code{at=numeric(0)} to suppress tick marks.}

\item{cborder}{logical. Border of rose plot.}

\item{...}{optional arguments passed to \code{plot.default()}}
}
\value{
none
}
\description{
Rose Diagram
}
\keyword{internal}
