#' @title library(tectonicr)
#'
#' @description
#' Modeling the Direction of the Maximum Horizontal Stress using Relative Plate
#' Motion
#'
#' @details
#' Further details and theoretical background are provided by Wdowinski
#' (1998) and Stephan et al. (2023).
#'
#' @references Wdowinski (1998) "A theory of intraplate tectonics".
#' *JGR: Solid Earth*, 103(3), 5037–5059.
#'
#' Stephan, T., Enkelmann, E., and Kroner, U. "Analyzing the horizontal
#' orientation of the crustal stress adjacent to plate boundaries".
#' *Sci Rep* 13. 15590 (2023).
#'
#' @note
#' A list of documented functions may be viewed by typing
#' \code{help(package="tectonicr")}.
#'
#' @author Tobias Stephan
#'
#' @name tectonicr
#'
#' @docType package
#'
#' @aliases tectonicr-package
#'
#' @keywords internal
"_PACKAGE"
