% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_nested_tabs.R
\name{module_teal_module}
\alias{module_teal_module}
\alias{ui_teal_module}
\alias{ui_teal_module.default}
\alias{ui_teal_module.teal_modules}
\alias{ui_teal_module.teal_module}
\alias{srv_teal_module}
\alias{srv_teal_module.default}
\alias{srv_teal_module.teal_modules}
\alias{srv_teal_module.teal_module}
\title{Calls all \code{modules}}
\usage{
ui_teal_module(id, modules, depth = 0L)

\method{ui_teal_module}{default}(id, modules, depth = 0L)

\method{ui_teal_module}{teal_modules}(id, modules, depth = 0L)

\method{ui_teal_module}{teal_module}(id, modules, depth = 0L)

srv_teal_module(
  id,
  data,
  modules,
  datasets = NULL,
  slices_global,
  reporter = teal.reporter::Reporter$new(),
  data_load_status = reactive("ok"),
  is_active = reactive(TRUE)
)

\method{srv_teal_module}{default}(
  id,
  data,
  modules,
  datasets = NULL,
  slices_global,
  reporter = teal.reporter::Reporter$new(),
  data_load_status = reactive("ok"),
  is_active = reactive(TRUE)
)

\method{srv_teal_module}{teal_modules}(
  id,
  data,
  modules,
  datasets = NULL,
  slices_global,
  reporter = teal.reporter::Reporter$new(),
  data_load_status = reactive("ok"),
  is_active = reactive(TRUE)
)

\method{srv_teal_module}{teal_module}(
  id,
  data,
  modules,
  datasets = NULL,
  slices_global,
  reporter = teal.reporter::Reporter$new(),
  data_load_status = reactive("ok"),
  is_active = reactive(TRUE)
)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{modules}{(\code{teal_modules})
\code{teal_modules} object. These are the specific output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{depth}{(\code{integer(1)})
number which helps to determine depth of the modules nesting.}

\item{data}{(\code{reactive} returning \code{teal_data})}

\item{datasets}{(\code{reactive} returning \code{FilteredData} or \code{NULL})
When \code{datasets} is passed from the parent module (\code{srv_teal}) then \code{dataset} is a singleton
which implies in filter-panel to be "global". When \code{NULL} then filter-panel is "module-specific".}

\item{slices_global}{(\code{reactiveVal} returning \code{modules_teal_slices})
see \code{\link{module_filter_manager}}}

\item{data_load_status}{(\code{reactive} returning \code{character})
Determines action dependent on a data loading status:
\itemize{
\item \code{"ok"} when \code{teal_data} is returned from the data loading.
\item \code{"teal_data_module failed"} when \code{\link[=teal_data_module]{teal_data_module()}} didn't return  \code{teal_data}. Disables tabs buttons.
\item \code{"external failed"} when a \code{reactive} passed to \code{srv_teal(data)} didn't return \code{teal_data}. Hides the whole tab
panel.
}}
}
\value{
output of currently active module.
\itemize{
\item \code{srv_teal_module.teal_module} returns \code{reactiveVal} containing output of the called module.
\item \code{srv_teal_module.teal_modules} returns output of module selected by \code{input$active_tab}.
}
}
\description{
On the UI side each \code{teal_modules} is translated to a \code{tabsetPanel} and each \code{teal_module} is a
\code{tabPanel}. Both, UI and server are called recursively so that each tab is a separate module and
reflect nested structure of \code{modules} argument.
}
\keyword{internal}
