% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_nested_tabs.R
\name{module_nested_tabs}
\alias{module_nested_tabs}
\alias{ui_nested_tabs}
\alias{ui_nested_tabs.default}
\alias{ui_nested_tabs.teal_modules}
\alias{ui_nested_tabs.teal_module}
\alias{srv_nested_tabs}
\alias{srv_nested_tabs.default}
\alias{srv_nested_tabs.teal_modules}
\alias{srv_nested_tabs.teal_module}
\title{Create a UI of nested tabs of \code{teal_modules}}
\usage{
ui_nested_tabs(id, modules, datasets, depth = 0L, is_module_specific = FALSE)

\method{ui_nested_tabs}{default}(id, modules, datasets, depth = 0L, is_module_specific = FALSE)

\method{ui_nested_tabs}{teal_modules}(id, modules, datasets, depth = 0L, is_module_specific = FALSE)

\method{ui_nested_tabs}{teal_module}(id, modules, datasets, depth = 0L, is_module_specific = FALSE)

srv_nested_tabs(
  id,
  datasets,
  modules,
  is_module_specific = FALSE,
  reporter = teal.reporter::Reporter$new()
)

\method{srv_nested_tabs}{default}(
  id,
  datasets,
  modules,
  is_module_specific = FALSE,
  reporter = teal.reporter::Reporter$new()
)

\method{srv_nested_tabs}{teal_modules}(
  id,
  datasets,
  modules,
  is_module_specific = FALSE,
  reporter = teal.reporter::Reporter$new()
)

\method{srv_nested_tabs}{teal_module}(
  id,
  datasets,
  modules,
  is_module_specific = TRUE,
  reporter = teal.reporter::Reporter$new()
)
}
\arguments{
\item{id}{(\code{character(1)})
module id}

\item{modules}{(\code{teal_modules}) object containing the output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{datasets}{(named \code{list} of \code{FilteredData})
object to store filter state and filtered datasets, shared across modules. For more
details see \code{\link[teal.slice:FilteredData]{teal.slice::FilteredData}}. Structure of the list must be the same as structure
of the \code{modules} argument and list names must correspond to the labels in \code{modules}.
When filter is not module-specific then list contains the same object in all elements.}

\item{depth}{(\code{integer(1)})
number which helps to determine depth of the modules nesting.}

\item{is_module_specific}{(\code{logical(1)})
flag determining if the filter panel is global or module-specific.
When set to \code{TRUE}, a filter panel is called inside of each module tab.}

\item{reporter}{(\code{Reporter}) object from \code{teal.reporter}}
}
\value{
Depending on the class of \code{modules}, \code{ui_nested_tabs} returns:
\itemize{
\item \code{teal_module}: instantiated UI of the module.
\item \code{teal_modules}: \code{tabsetPanel} with each tab corresponding to recursively
calling this function on it.
}

\code{srv_nested_tabs} returns a reactive which returns the active module that corresponds to the selected tab.
}
\description{
Create a UI of nested tabs of \code{teal_modules}
}
\section{\code{ui_nested_tabs}}{

Each \code{teal_modules} is translated to a \code{tabsetPanel} and each
of its children is another tab-module called recursively. The UI of a
\code{teal_module} is obtained by calling its UI function.

The \code{datasets} argument is required to resolve the \code{teal} arguments in an
isolated context (with respect to reactivity).
}

\section{\code{srv_nested_tabs}}{

This module recursively calls all elements of \code{modules} and returns currently active one.
\itemize{
\item \code{teal_module} returns self as a active module.
\item \code{teal_modules} also returns module active within self which is determined by the \code{input$active_tab}.
}
}

\keyword{internal}
