% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slice.R
\name{teal_slice-utilities}
\alias{teal_slice-utilities}
\alias{is.teal_slice}
\alias{as.teal_slice}
\alias{as.list.teal_slice}
\alias{format.teal_slice}
\alias{print.teal_slice}
\title{\code{teal_slice} utility functions}
\usage{
is.teal_slice(x)

as.teal_slice(x)

\method{as.list}{teal_slice}(x, ...)

\method{format}{teal_slice}(x, show_all = FALSE, trim_lines = TRUE, ...)

\method{print}{teal_slice}(x, ...)
}
\arguments{
\item{x}{(\code{teal.slice})}

\item{...}{additional arguments passed to other functions.}

\item{show_all}{(\code{logical(1)}) indicating whether to show all fields. If set to \code{FALSE},
only non-NULL elements will be printed.}

\item{trim_lines}{(\code{logical(1)}) indicating whether to trim lines when printing.}
}
\description{
Helper functions for working with \code{\link{teal_slice}} object.
}
\examples{
x1 <- teal_slice(
  dataname = "data",
  id = "Female adults",
  expr = "SEX == 'F' & AGE >= 18",
  title = "Female adults"
)
x2 <- teal_slice(
  dataname = "data",
  varname = "var",
  choices = c("F", "M", "U"),
  selected = "F",
  keep_na = TRUE,
  keep_inf = TRUE,
  fixed = FALSE,
  anchored = FALSE,
  multiple = TRUE,
  id = "Gender",
  extra_arg = "extra"
)

is.teal_slice(x1)
as.list(x1)
as.teal_slice(list(dataname = "a", varname = "var"))
format(x1)
format(x1, show_all = TRUE, trim_lines = FALSE)
print(x1)
print(x1, show_all = TRUE, trim_lines = FALSE)

}
\keyword{internal}
