% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_distribution.R
\name{tm_g_distribution}
\alias{tm_g_distribution}
\title{\code{teal} module: Distribution analysis}
\usage{
tm_g_distribution(
  label = "Distribution Module",
  dist_var,
  strata_var = NULL,
  group_var = NULL,
  freq = FALSE,
  ggtheme = c("gray", "bw", "linedraw", "light", "dark", "minimal", "classic", "void"),
  ggplot2_args = teal.widgets::ggplot2_args(),
  bins = c(30L, 1L, 100L),
  plot_height = c(600, 200, 2000),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{dist_var}{(\code{data_extract_spec} or \code{list} of multiple \code{data_extract_spec})
Variable(s) for which the distribution will be analyzed.}

\item{strata_var}{(\code{data_extract_spec} or \code{list} of multiple \code{data_extract_spec})
Categorical variable used to split the distribution analysis.}

\item{group_var}{(\code{data_extract_spec} or \code{list} of multiple \code{data_extract_spec})
Variable used for faceting plot into multiple panels.}

\item{freq}{(\code{logical}) optional, whether to display frequency (\code{TRUE}) or density (\code{FALSE}).
Defaults to density (\code{FALSE}).}

\item{ggtheme}{(\code{character}) optional, \code{ggplot2} theme to be used by default. Defaults to \code{"gray"}.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional, object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}}
with settings for all the plots or named list of \code{ggplot2_args} objects for plot-specific settings.
The argument is merged with options variable \code{teal.ggplot2_args} and default module setup.

List names should match the following: \code{c("default", "Histogram", "QQplot")}.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{bins}{(\code{integer(1)} or \code{integer(3)}) optional,  specifies the number of bins for the histogram.
\itemize{
\item When the length of \code{bins} is one: The histogram bins will have a fixed size based on the \code{bins} provided.
\item When the length of \code{bins} is three: The histogram bins are dynamically adjusted based on vector of \code{value}, \code{min},
and \code{max}.
Defaults to \code{c(30L, 1L, 100L)}.
}}

\item{plot_height}{(\code{numeric}) optional, specifies the plot height as a three-element vector of
\code{value}, \code{min}, and \code{max} intended for use with a slider UI element.}

\item{plot_width}{(\code{numeric}) optional, specifies the plot width as a three-element vector of
\code{value}, \code{min}, and \code{max} for a slider encoding the plot width.}

\item{pre_output}{(\code{shiny.tag}, optional)\cr
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}, optional) with text placed after the output to put the output
into context. For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
Module is designed to explore the distribution of a single variable within a given dataset.
It offers several tools, such as histograms, Q-Q plots, and various statistical tests to
visually and statistically analyze the variable's distribution.
}
\examples{
library(teal.widgets)

# general data example
data <- teal_data()
data <- within(data, {
  iris <- iris
})
datanames(data) <- "iris"

app <- init(
  data = data,
  modules = list(
    tm_g_distribution(
      dist_var = data_extract_spec(
        dataname = "iris",
        select = select_spec(variable_choices("iris"), "Petal.Length")
      ),
      ggplot2_args = ggplot2_args(
        labs = list(subtitle = "Plot generated by Distribution Module")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

# CDISC data example
data <- teal_data()
data <- within(data, {
  ADSL <- rADSL
})
datanames(data) <- c("ADSL")
join_keys(data) <- default_cdisc_join_keys[datanames(data)]

vars1 <- choices_selected(
  variable_choices(data[["ADSL"]], c("ARM", "COUNTRY", "SEX")),
  selected = NULL
)

app <- init(
  data = data,
  modules = modules(
    tm_g_distribution(
      dist_var = data_extract_spec(
        dataname = "ADSL",
        select = select_spec(
          choices = variable_choices(data[["ADSL"]], c("AGE", "BMRKR1")),
          selected = "BMRKR1",
          multiple = FALSE,
          fixed = FALSE
        )
      ),
      strata_var = data_extract_spec(
        dataname = "ADSL",
        filter = filter_spec(
          vars = vars1,
          multiple = TRUE
        )
      ),
      group_var = data_extract_spec(
        dataname = "ADSL",
        filter = filter_spec(
          vars = vars1,
          multiple = TRUE
        )
      ),
      ggplot2_args = ggplot2_args(
        labs = list(subtitle = "Plot generated by Distribution Module")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
