% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gadget_clean_columns.R
\name{gadget_clean_columns}
\alias{gadget_clean_columns}
\title{Visually remove columns from data set}
\usage{
gadget_clean_columns(
  data,
  rownames = TRUE,
  theme = "flatly",
  width = "100\%",
  height = "600px",
  css = NULL
)
}
\arguments{
\item{data}{A data set}

\item{rownames}{\code{logical} Should rownames be included?}

\item{theme}{\code{character} A bootswatch theme provided to \code{shinythemes::shinytheme}}

\item{width}{\code{character} Width of the gadget (in valid css units)}

\item{height}{\code{character} Height of the gadget (in valid css units)}

\item{css}{\code{character} Path to a custom css file}
}
\value{
A \code{list} of length 2
  \item{data}{A \code{data.frame} containing the columns that were not removed}
  \item{script}{A line of code that can be used to replicate cleaning performed in the gadget}

A printed shiny app
}
\description{
Shiny gadget used to visually inspect columns in a data set and select columns to remove
}
\examples{
\dontrun{clean_columns(mtcars)}

}
\concept{shinygadgets}
