# output file of Carbamazepine including individual information and predict PK parameters obtained from multiple cocentrations
Carsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Carbamazepine >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)  
cat("\n")
show(F)    
     cat("-----------------------------------------------------------\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl_F = clerance (L/hr)                 \n")
     cat("    V_F = volume of distribution (L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Aminoglycoside including individual information and predict PK parameters obtained from multiple cocentrations
Amism.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Aminoglycoside >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("----------------------------------------------------\n")
     cat("    --Aminoglycoside input data information--       \n")
     cat("    Gender = Male=1 ; Female=0                      \n")
     cat("    age = age(yr)                                   \n")
     cat("    bw = body weight(kg)                            \n")
     cat("    Ht = height(cm)                                 \n")
     cat("    Scr = serum creatinine conc.(mg/dL)             \n")
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    tin = infusion time(hr)                         \n")
     cat("    ts = sampling time since infusion end (hr)      \n")
     cat("    c = measured steady-state conc.(mg/L)           \n") 
     cat("----------------------------------------------------\n")     
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of children Valproate including individual information and predict PK parameters obtained from multiple cocentrations
ChiValsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << children Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("    --Children Valpraote input data information--     \n")
     cat("    TBW = total body weight (Kg)                      \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)            \n")
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n") 
     cat("    c = measured steady-state conc.(mg/L)             \n")  
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Children Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Valproate including individual information and predict PK parameters obtained from multiple cocentrations
Valsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-------------------------------------------------------------\n")
     cat("   --Valpraote input data information--                      \n")
     cat("   age = age (yr)                                            \n")   
     cat("   INDI(indication)=1 for uncontrolled epilepsy, otherwise 0 \n")
     cat("   CBZ = combine CArbamazepine (Y=1, N=0)                    \n")
     cat("   ka = 4 for oral solution, 1 for enteric tablet            \n")
     cat("   D = dose for each dosing interval(mg)                     \n") 
     cat("   tau = dosing interval(hr)                                 \n")
     cat("   ts = sampling time (hr)                                   \n") 
     cat("   c = measured steady-state conc.(mg/L)                     \n")  
     cat("-------------------------------------------------------------\n")  
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Vancomycin including individual information and predict PK parameters obtained from multiple cocentrations
Vansm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Vancomycin >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("---------------------------------------------------\n")
     cat("    --Vancomycin input data information--          \n")
     cat("    Gender = 1 for Male ; 0 for Female             \n")
     cat("    age = age(yr)                                  \n")
     cat("    bw = body weight (kg)                          \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)            \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    tin = infusion time(hr)                        \n") 
     cat("    ts = sampling time since infusion end (hr)     \n") 
     cat("    c = measured steady-state conc.(mg/L)          \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Vancomycin output data information--            \n")
     cat("    cl = clerance(L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}



# output file of Enfuvirtide including individual information and predict PK parameters obtained from multiple cocentrations
Enfsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Enfuvirtide >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------\n")
     cat("    --Enfuvirtide input data information--      \n")
     cat("    Gender : 1 for Male ; 0 for Female          \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mg/L)       \n")
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}



# output file of Indinavir including individual information and predict PK parameters obtained from multiple cocentrations
Indsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Indinavir >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-----------------------------------------------\n")
     cat("    --Indinavir input data information--       \n")
     cat("    Gender = 1 for Male ; 0 for Female         \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    ts = sampling time(hr)                     \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")    
     cat("-----------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
      cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Ritonavir including individual information and predict PK parameters obtained from multiple cocentrations
Ritsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Ritonavir >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------\n")
     cat("    --Ritonavir input data information--        \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-stat conc.(mg/L)        \n")    
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Cyclosporine including individual information and predict PK parameters obtained from multiple cocentrations
Cycsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Cyclosporine >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("---------------------------------------------------\n")
     cat("    --Cyclosporine input data information--        \n")
     cat("    bw = body weight(kg)                           \n")
     cat("    PTD = post-transplant day(day)                 \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)               \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    ts = sampling time(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)         \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance(L/hr)                   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}



# output file of Everolimus including individual information and predict PK parameters obtained from multiple cocentrations
Evesm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Everolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------\n")
     cat("    --Everolimus input data information--       \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    age = age(yr)                               \n")
     cat("    race = 1 for black ; otherwise 0            \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mcg/L)      \n")  
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Tacrolimus including individual information and predict PK parameters obtained from multiple cocentrations
Tacsm.pkoutput<-function(B,F,G){
cat("\n")
cat("Report from tdm   << Tacrolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("    --Tacrolimus input data information--             \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1        \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1       \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                 \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)               \n")
     cat("    D = dose for each dosing interval(mg)             \n")
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time(hr)                            \n")  
     cat("    c = measured steady-state conc.(mcg/mL)           \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
     cat("-----------------------------------------------------------\n")
     cat("   --Tacrolimus output data information--                  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("-----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}



# output file of Imatinib mesylate including individual information and predict PK parameters obtained from multiple cocentrations
Imasm.pkoutput<-function(B,F,H){
cat("\n")
cat("Report from tdm   << Imatinib mesylate >>\n")
cat("====================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("====================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("    --Imatinib mesylate input data information--      \n")
     cat("    BW = body weight(kg)                              \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                \n")
     cat("    Hb = Hemoglobin (g/dL)                            \n")
     cat("    WBC = white blood count (10^9/L)                  \n")
     cat("    n = dosing number                                 \n") 
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n")
     cat("    c = measured conc.(mg/L)                          \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Imatinib mesylate output data information--         \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("====================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous IR including individual information and predict PK parameters obtained from multiple cocentrations
Amianhirsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline dihydrous IR including individual information and predict PK parameters obtained from multiple cocentrations
Amidihirsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Oxtriphylline I including individual information and predict PK parameters obtained from multiple cocentrations
Oxtirsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Oxtriphylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-------------------------------------------------\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("---------------------------------------------------------\n")
     cat("   --Oxtriphylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}



# output file of Theophylline IR including individual information and predict PK parameters obtained from multiple cocentrations
Theirsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Theophylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("-------------------------------------------------\n")
     cat("    --Theophylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("---------------------------------------------------------\n")
     cat("   --Theophylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous iv infusion including individual information and predict PK parameters obtained from multiple cocentrations
Amianhinfusionsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("--------------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("--------------------------------------------------------------------\n\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous iv infusion output data information--  \n")
     cat("    cl = clerance (L/hr)                 \n")
     cat("    v = volume of distribution (L)       \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline dihydrous iv infusion including individual information and predict PK parameters obtained from multiple cocentrations
Amidihinfusionsm.pkoutput<-function(B,F,G,H){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.1.0, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
cat("\n")
show(F)
     cat("--------------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("--------------------------------------------------------------------\n\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(G)
show(H)
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous iv infusion output data information--  \n")
     cat("    cl = clerance (L/hr)                          \n")
     cat("    v = volume of distribution (L)                \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}

