% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPortfolio.R
\name{getPortfolio}
\alias{getPortfolio}
\title{Download information about current portfolio}
\usage{
getPortfolio(token = "", live = FALSE, verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the information about current portfolio state.
}
\description{
Makes a request to the server, and returns an data.table object with information about portfolio if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getPortfolio(token,live)
}
\seealso{
\code{\link{getTrades}} \code{\link{getOrders}}
}
\author{
Vyacheslav Arbuzov
}
