% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrderBook.R
\name{getOrderBook}
\alias{getOrderBook}
\title{Download current OrderBook snapshot}
\usage{
getOrderBook(
  token = "",
  live = FALSE,
  figi = "",
  depth = NULL,
  verbose = FALSE
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{figi}{internal tinkoff code for instrument}

\item{depth}{depth of orderbook, number of bids and asks (1 <= depth <= 20)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the information about current OrderBook.
}
\description{
Makes a request to the server, and returns an data.table object with information about orderbook for selected instrument if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getOrderBook(token,live,figi = 'BBG005HLTYH9',depth = 5)
}
\seealso{
\code{\link{getHistoricalData}}
}
\author{
Vyacheslav Arbuzov
}
