% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBonds.R
\name{getBonds}
\alias{getBonds}
\title{Download Bond data}
\usage{
getBonds(token = "", live = FALSE, verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the list of available bonds.
}
\description{
Makes a request to the server, and returns an data.table object with information about available bonds if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getBonds(token,live)
}
\seealso{
\code{\link{getETFs}} \code{\link{getCurrencies}} \code{\link{getStocks}}
}
\author{
Vyacheslav Arbuzov
}
