% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay_funcs.R, R/tcplLoadAcid.R, R/tcplLoadAeid.R, R/tcplLoadAid.R, R/tcplLoadAsid.R
\name{Load assay information}
\alias{Load assay information}
\alias{tcplLoadAcid}
\alias{tcplLoadAeid}
\alias{tcplLoadAid}
\alias{tcplLoadAsid}
\title{Functions for loading assay information}
\usage{
tcplLoadAcid(fld = NULL, val = NULL, add.fld = NULL)

tcplLoadAeid(fld = NULL, val = NULL, add.fld = NULL)

tcplLoadAid(fld = NULL, val = NULL, add.fld = NULL)

tcplLoadAsid(fld = NULL, val = NULL, add.fld = NULL)
}
\arguments{
\item{fld}{Character, the field(s) to query/subset on}

\item{val}{List, vectors of values for each field to query/subset on. Must 
be in the same order as 'fld'.}

\item{add.fld}{Character, additional field(s) to include, but not query/
subset on}
}
\value{
A data.table containing the ID, name, and any additional fields.
}
\description{
These functions query the tcpl databases and returns a data.table with 
assay ID and name information. More information about the assay
hierarchy is available in the overview vignette.
}
\details{
Each element in the assay hierarchy has its own function, loading the ID and
name for the given assay element. For example, \code{tcplLoadAsid} will 
return the assay source ID (asid) and assay source name (asnm).
}
\examples{
## Store the current config settings, so they can be reloaded at the end 
## of the examples
conf_store <- tcplConfList()
tcplConfDefault()

## The load assay functions can be used without any parameters to list the 
## full list of registered assay elements:
tcplLoadAsid()
tcplLoadAeid()

## Similarly, the user can add fields without doing any element selection:
tcplLoadAeid(add.fld = c("asid", "aid", "acid"))

## Or, the user can look only at a subset:
tcplLoadAeid(fld = "aeid", val = 1, add.fld = "asid")

## The field can be any value in one of the corresponding assay element
## tables, but the functions also recognize the abbreviated version of
## the name fields.
tcplListFlds("assay")
a1 <- tcplLoadAeid(fld = "anm", val = "Steroidogenesis")
a2 <- tcplLoadAeid(fld = "assay_name", val = "Steroidogenesis")
identical(a1, a2)

## Reset configuration
options(conf_store)

}

