% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplWriteData.R
\name{tcplWriteData}
\alias{tcplWriteData}
\title{Write screening data into the tcpl databases}
\usage{
tcplWriteData(dat, lvl, type)
}
\arguments{
\item{dat}{data.table, the screening data to load}

\item{lvl}{Integer of length 1, the data processing level}

\item{type}{Character of length 1, the data type, "sc" or "mc"}
}
\description{
\code{tcplWriteData} takes a data.table with screening data and writes the 
data into the given level table in the tcpl databases.
}
\details{
This function appends data onto the existing table. It also deletes all the 
data for any acids or aeids dat contains from the given and all downstream 
tables.

The data type can be either 'mc' for mutliple concentration data, or 'sc'
for single concentration data. Multiple concentration data will be loaded
into the level tables, whereas the single concentration will be loaded into
the single tables.
}
\note{
This function is not exported and is not inteded to be used by the user. 
The user should only write level 0 data, which is written with 
\code{\link{tcplWriteLvl0}}.
}
\seealso{
\code{\link{tcplCascade}}, \code{\link{tcplAppend}},
\code{\link{tcplWriteLvl0}}
}

