% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{repLoad}
\alias{repLoad}
\title{Parse input files or folders with immune receptor repertoire data.}
\usage{
repLoad(.path, .format = c("mitcr", "migec"))
}
\arguments{
\item{.path}{Character vector with path to files and / or folders.}

\item{.format}{String that specifies the input format.}
}
\description{
Load the immune receptor repertoire data from the given input: either a file name, a list of file names, a name of the folder with repertoire files,
or a list of folders with repertoire files. The folder / folders must contain only files with the specified format.
Input files could be either text files or archived with gzip ("filename.txt.gz") or bzip2 ("filename.txt.bz2").
For a general parser of table files with cloneset data see \code{\link{parse.cloneset}}.

Parsers are available for:
MiTCR ("mitcr"), MiTCR w/ UMIs ("mitcrbc"), MiGEC ("migec"), VDJtools ("vdjtools"), 
ImmunoSEQ ("immunoseq" or 'immunoseq2' for old and new formats respectively),
MiXCR ("mixcr"), IMSEQ ("imseq") and tcR ("tcr", data frames saved with the `repSave()` function).

Output of MiXCR should contain either all hits or best hits for each gene segment.

Output of IMSEQ should be generated with parameter "-on". In this case there will be no positions of aligned gene segments in the output data frame
due to restrictions of IMSEQ output.

tcR's data frames should be saved with the `repSave()` function.

For details on the tcR data frame format see \link{parse.file}.
}
\examples{
\dontrun{
datalist <- repLoad(c("file1.txt", "folder_with_files1", "another_folder"), "mixcr")
}
}
\seealso{
\link{parse.file}
}
