% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/graph.R
\name{set.people.vector}
\alias{get.people.names}
\alias{set.people.vector}
\title{Set and get attributes of a mutation network related to source people.}
\usage{
set.people.vector(.G, .shared.rep)

get.people.names(.G, .V = V(.G), .paste = T)
}
\arguments{
\item{.G}{Mutation network.}

\item{.shared.rep}{Shared repertoire.}

\item{.V}{Indices of vertices.}

\item{.paste}{If TRUE than concatenate people names to one string, else get a character vector of names.}
}
\value{
New graph with 'people' and 'npeople' vertex attributes or character vector of length .V or list of length .V.
}
\description{
Set vertice attributes 'people' and 'npeople' for every vertex in the given graph.
Attribute 'people' is a binary string indicating in which repertoire sequence are
found. Attribute 'npeople' is a integer indicating number of repertoires, in which
this sequence has been found.
}
\examples{
\dontrun{
data(twb)
twb.shared <- shared.repertoire(twb)
G <- mutation.network(twb.shared)
get.people.names(G, 300, T)  # "Subj.A|Subj.B"
get.people.names(G, 300, F)  # list(c("Subj.A", "Subj.B"))
}
}

