% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vis.heatmap}
\alias{vis.heatmap}
\title{Heatmap.}
\usage{
vis.heatmap(.data, .title = "Number of shared clonotypes",
  .labs = "Subject", .legend = "Shared clonotypes", .na.value = NA,
  .text = T)
}
\arguments{
\item{.data}{Either a matrix with colnames and rownames specifyed or a data.frame with the first column of
strings for row names and other columns stands for values.}

\item{.title}{Main title of the plot.}

\item{.labs}{Labs names. Character vector of length 1 (for naming both axis with same name) or 2 (first elements stands for x-axis).}

\item{.legend}{Title for the legend.}

\item{.na.value}{Replace NAs with this values.}

\item{.text}{If T than print \code{.data} values at tiles.}
}
\value{
ggplot object.
}
\description{
Plot a heatmap from a matrix or a data.frame
}
\examples{
\dontrun{
# Load your data.
load('immdata.rda')
# Perform intersection by amino acid sequences with V-segments.
imm.av <- intersect(immdata, 'ave')
# Plot a heatmap.
vis.heatmap(imm.av, .title = 'Immdata - (ave)-intersection')
}
}

