% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_xts.R
\name{tbl_xts}
\alias{tbl_xts}
\title{tbl_xts}
\usage{
tbl_xts(tblData, cols_to_xts, spread_by, spread_name_pos = "Suffix")
}
\arguments{
\item{tblData}{A tbl_df type dataframe}

\item{cols_to_xts}{Specify the columns to be converted to xts format. If not provided, it will by default transform all numeric columns to xts.}

\item{spread_by}{A character or factor type column used to create xts series by. See example.}

\item{spread_name_pos}{Add the column name of the column used to spread_by as a Suffix, Prefix or None. Defaults to Suffix (puts spread_by name at end of colname, separated by an underscore).}
}
\value{
A xts dataframe, with columns xts series ordered by the first (date) column.
}
\description{
This function converts data from a tbl_df() format into a xts format.
Note that the dataframe must be a data.frame or tbl_df, and either the first column must be a valid date column, or there must be one column named date, Date or DATE to order by.
tbl_xts also allows the user to specify the columns to be transformed to xts, as well as an option for spreading by a single character or factor type column. See the example for details.
}
\examples{
library(dplyr)
library(tbl2xts)
data(TRI)
tbl_xts(TRI, cols_to_xts = "TRI", spread_by = "Country")
}
