% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-color-scales.R
\name{scale_fill_albums}
\alias{scale_fill_albums}
\alias{scale_colour_albums}
\alias{scale_color_albums}
\title{Taylor Swift colour scale for album comparisons}
\usage{
scale_fill_albums(
  ...,
  aesthetics = "fill",
  breaks = waiver(),
  limits = force,
  na.value = NA
)

scale_colour_albums(
  ...,
  aesthetics = "colour",
  breaks = waiver(),
  limits = force,
  na.value = NA
)

scale_color_albums(
  ...,
  aesthetics = "colour",
  breaks = waiver(),
  limits = force,
  na.value = NA
)
}
\arguments{
\item{...}{Other arguments to be passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones
}}

\item{na.value}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
}
\value{
A color scale for use in plots created with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
A convenience wrapper for comparing albums with color. In contrast to
\code{\link[=scale_fill_taylor_d]{scale_fill_taylor_d()}} and \code{\link[=scale_colour_taylor_d]{scale_colour_taylor_d()}},
\code{scale_fill_albums()} and \code{scale_colour_albums()} use a single palette, with
one color per album. Specifically, the \code{\link{album_compare}} palette is used to
apply a color associated with each album.
}
\examples{
library(ggplot2)
studio <- subset(taylor_albums, !is.na(metacritic_score))

# create a plot that we want to color or fill by album
ggplot(studio, aes(x = metacritic_score, y = album_name)) +
  geom_col(aes(fill = album_name))

# apply a color inspired by each album cover
ggplot(studio, aes(x = metacritic_score, y = album_name)) +
  geom_col(aes(fill = album_name)) +
  scale_fill_albums()

# even when the axis or levels are rearranged, the correct color is applied
studio$album_name <- factor(studio$album_name, levels = album_levels)
ggplot(studio, aes(x = metacritic_score, y = album_name)) +
  geom_col(aes(fill = album_name)) +
  scale_fill_albums()
}
