% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{condenseTaxa}
\alias{condenseTaxa}
\title{Condense multiple taxonomic assignments to their most recent common branch}
\usage{
condenseTaxa(taxaTable, groupings = rep(1, nrow(taxaTable)))
}
\arguments{
\item{taxaTable}{a matrix or data.frame with hits on the rows and various levels of taxonomy in the columns}

\item{groupings}{a vector of groups e.g. read queries to condense taxa within}
}
\value{
a matrix with \code{ncol(taxaTable)} taxonomy columns with a row for each unique id (labelled on rownames) with NAs where there was not complete agreement for an id
}
\description{
Take a table of taxonomic assignments, e.g. assignments from hits to a read, and condense it to a single vector with NAs where there are disagreements between the hits.
}
\examples{
taxas<-matrix(c(
 'a','b','c','e',
 'a','b','d','e'
),nrow=2,byrow=TRUE)
condenseTaxa(taxas)
condenseTaxa(taxas[c(1,2,2),],c(1,1,2))
}
