% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{read.accession2taxid}
\alias{read.accession2taxid}
\title{Read NCBI accession2taxid files}
\usage{
read.accession2taxid(taxaFiles, sqlFile, vocal = TRUE, extraSqlCommand = "")
}
\arguments{
\item{taxaFiles}{a string or vector of strings giving the path(s) to files to be read in}

\item{sqlFile}{a string giving the path where the output sqlite file should be saved}

\item{vocal}{if TRUE output status messages}

\item{extraSqlCommand}{for advanced use. A string giving a command to be called on the sqlite databse before loading data e.g. "pragma temp_store = 2;" to keep all temp files in memory (don't do this unless you have a lot (>100 Gb) of RAM)}
}
\value{
TRUE if sucessful
}
\description{
Take NCBI accession2taxid files, keep only accession and taxa and save it as a sqlite database
}
\examples{
taxa<-c(
  "accession\\taccession.version\\ttaxid\\tgi",
  "Z17427\\tZ17427.1\\t3702\\t16569",
  "Z17428\\tZ17428.1\\t3702\\t16570",
  "Z17429\\tZ17429.1\\t3702\\t16571",
  "Z17430\\tZ17430.1\\t3702\\t16572"
)
inFile<-tempfile()
outFile<-tempfile()
writeLines(taxa,inFile)
read.accession2taxid(inFile,outFile)
db<-RSQLite::dbConnect(RSQLite::SQLite(),dbname=outFile)
RSQLite::dbGetQuery(db,'SELECT * FROM accessionTaxa')
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/accession2taxid}
}
\seealso{
\code{\link{read.nodes}}, \code{\link{read.names}}
}
