% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{getAccession2taxid}
\alias{getAccession2taxid}
\title{Download accession2taxid files from NCBI}
\usage{
getAccession2taxid(outDir = ".",
  baseUrl = "ftp://ftp.ncbi.nih.gov/pub/taxonomy/accession2taxid/",
  types = c("nucl_gb", "nucl_est", "nucl_gss", "nucl_wgs"))
}
\arguments{
\item{outDir}{the directory to put the accession2taxid.gz files in}

\item{baseUrl}{the url of the directory where accession2taxid.gz files are located}

\item{types}{the types if accession2taxid.gz files desired where type is the prefix of xxx.accession2taxid.gz. The default is to download all nucl_ accessions. For protein accessions, try \code{types=c('prot')}.}
}
\value{
a vector of file path strings of the locations of the output files
}
\description{
Download a nucl_xxx.accession2taxid.gz from NCBI servers. These can then be used to create a SQLite datanase with \code{\link{read.accession2taxid}}. Note that if the files already exist in the target directory then this function will not redownload them. Delete the files if a fresh download is desired.
}
\examples{
\dontrun{
  getAccession2taxid()
}
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/}, \url{https://www.ncbi.nlm.nih.gov/Sequin/acc.html}
}
\seealso{
\code{\link{read.accession2taxid}}
}
