% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_rank.R
\name{tax_rank}
\alias{tax_rank}
\title{Get rank for a given taxonomic name.}
\usage{
tax_rank(x, db = NULL, rows = NA, ...)
}
\arguments{
\item{x}{(character) Vector of one or more taxon names (character) or
IDs (character or numeric) to query. Or objects returned from \verb{get_*()}
functions like \code{\link[=get_tsn]{get_tsn()}}}

\item{db}{(character) database to query. either \code{ncbi}, \code{itis}, \code{eol},
\code{tropicos}, \code{gbif},\code{nbn}, \code{worms}, \code{natserv}, \code{bold}. Note that each
taxonomic data source has their own identifiers, so that if you provide the
wrong \code{db} value for the identifier you may get a result, but it will
likely be wrong (not what you were expecting). If using ncbi or eol we
recommend getting an API key; see \link{taxize-authentication}}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA,
all rows are considered. passed down to \verb{get_*()} functions.}

\item{...}{Additional arguments to \code{\link[=classification]{classification()}}}
}
\value{
A named list of character vectors with ranks (all lower-cased)
}
\description{
Get rank for a given taxonomic name.
}
\note{
While \code{\link[=tax_name]{tax_name()}} returns the name of a specified
rank, \code{\link[=tax_rank]{tax_rank()}} returns the actual rank of the taxon.
}
\examples{
\dontrun{
tax_rank(x = "Helianthus annuus", db = "itis")
tax_rank(get_tsn("Helianthus annuus"))
tax_rank(c("Helianthus", "Pinus", "Poa"), db = "itis")

tax_rank(get_boldid("Helianthus annuus"))
tax_rank("421377", db = "bold")
tax_rank(421377, db = "bold")

tax_rank(c("Plantae", "Helianthus annuus",
  "Puma", "Homo sapiens"), db = 'itis')
tax_rank(c("Helianthus annuus", "Quercus", "Fabaceae"), db = 'tropicos')

tax_rank(names_list("species"), db = 'gbif')
tax_rank(names_list("family"), db = 'gbif')

tax_rank(c("Gadus morhua", "Lichenopora neapolitana"),
  db = "worms")
}
}
\seealso{
\code{\link[=classification]{classification()}},\code{\link[=tax_name]{tax_name()}}
}
