% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_boldid}
\alias{get_boldid}
\title{Get the BOLD (Barcode of Life) code for a search term.}
\usage{
get_boldid(searchterm, fuzzy = FALSE, dataTypes = "basic",
  includeTree = FALSE, ask = TRUE, verbose = TRUE)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.}

\item{fuzzy}{(logical) Whether to use fuzzy search or not (default: FALSE).}

\item{dataTypes}{(character) Specifies the datatypes that will be returned. See Details for
options.}

\item{includeTree}{(logical) If TRUE (default: FALSE), returns a list containing information
for parent taxa as well as the specified taxon.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for teh species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; should progress be printed?}
}
\value{
A vector of BOLD ids. If a taxon is not found NA. If more than one BOLD ID is found
   the function asks for user input (if ask = TRUE), otherwise returns NA.
   Comes with an attribute \emph{match} to investigate the reason for NA (either 'not found',
   'found' or if ask = FALSE 'multi match')
}
\description{
Get the BOLD (Barcode of Life) code for a search term.
}
\examples{
\donttest{
get_boldid(searchterm = "Agapostemon")
get_boldid(searchterm = "Chironomus riparius")
get_boldid(c("Chironomus riparius","Quercus douglasii")) # needs error catching
splist <- names_list('species')
get_boldid(splist, verbose=FALSE)

# Fuzzy searching
get_boldid(searchterm="Osmi", fuzzy=TRUE)

# When not found
get_boldid("howdy")
get_boldid(c("Chironomus riparius", "howdy"))
}
}
\seealso{
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{classification}}
}

