% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{data_used}
\alias{data_used}
\title{Get values of data used in expressions}
\arguments{
\item{obj}{a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object}

\item{...}{One or more expressions}
}
\value{
\code{list}
}
\description{
Get values available for
\href{http://adv-r.had.co.nz/Computing-on-the-language.html}{non-standard evaluation}
in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object used in expressions. Expressions are
not evaluated and do not need to make sense.
\preformatted{
obj$data_used(...)}
}
\examples{
# Get values for variables names used in expressions
ex_taxmap$data_used(n_legs + dangerous == invalid_expression)
ex_taxmap$data_used(length(unique(taxon_names)))

}
\seealso{
Other NSE helpers: 
\code{\link{all_names}()},
\code{\link{get_data}()},
\code{\link{names_used}}
}
\concept{NSE helpers}
\keyword{internal}
