tar_test("tar_exist_script()", {
  expect_false(tar_exist_script())
  tar_script()
  expect_true(tar_exist_script())
})

tar_test("custom script and store args", {
  skip_cran()
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(tar_exist_script(script = "example/script.R"))
  tar_script(tar_target(x, 1), script = "example/script.R")
  expect_true(tar_exist_script(script = "example/script.R"))
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  expect_equal(tar_config_get("store"), path_store_default())
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
  expect_true(file.exists("example/script.R"))
  tar_config_set(script = "x")
  expect_equal(tar_config_get("script"), "x")
  expect_true(file.exists("_targets.yaml"))
})
