% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_name.R
\name{tar_name}
\alias{tar_name}
\title{Get the name of the target currently running.}
\usage{
tar_name(default = "target")
}
\arguments{
\item{default}{Character, value to return if \code{tar_name()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}
}
\value{
Character of length 1. If called inside a pipeline,
\code{tar_name()} returns name of the target currently running.
Otherwise, the return value is \code{default}.
}
\description{
Get the name of the target currently running.
}
\examples{
tar_name()
tar_name(default = "custom_target_name")
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(x, tar_name()), ask = FALSE)
tar_make()
tar_read(x)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
